/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.test.bpmn.common.AbstractProcessEngineServicesAccessTest;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;

public class TaskListenerProcessEngineServicesAccessTest
extends AbstractProcessEngineServicesAccessTest {
    @Override
    protected Class<?> getTestServiceAccessibleClass() {
        return AccessServicesListener.class;
    }

    @Override
    protected Class<?> getQueryClass() {
        return PerformQueryListener.class;
    }

    @Override
    protected Class<?> getStartProcessInstanceClass() {
        return StartProcessListener.class;
    }

    @Override
    protected Class<?> getProcessEngineStartProcessClass() {
        return ProcessEngineStartProcessListener.class;
    }

    @Override
    protected Task createModelAccessTask(BpmnModelInstance modelInstance, Class<?> delegateClass) {
        UserTask task = (UserTask)modelInstance.newInstance(UserTask.class);
        task.setId("userTask");
        CamundaTaskListener executionListener = (CamundaTaskListener)modelInstance.newInstance(CamundaTaskListener.class);
        executionListener.setCamundaEvent("create");
        executionListener.setCamundaClass(delegateClass.getName());
        task.builder().addExtensionElement((BpmnModelElementInstance)executionListener);
        return task;
    }

    public static class ProcessEngineStartProcessListener
    implements TaskListener {
        public void notify(DelegateTask execution) {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngine());
        }
    }

    public static class StartProcessListener
    implements TaskListener {
        public void notify(DelegateTask execution) {
            AbstractProcessEngineServicesAccessTest.assertCanStartProcessInstance(execution.getProcessEngineServices());
        }
    }

    public static class PerformQueryListener
    implements TaskListener {
        public void notify(DelegateTask execution) {
            AbstractProcessEngineServicesAccessTest.assertCanPerformQuery(execution.getProcessEngineServices());
        }
    }

    public static class AccessServicesListener
    implements TaskListener {
        public void notify(DelegateTask execution) {
            AbstractProcessEngineServicesAccessTest.assertCanAccessServices(execution.getProcessEngineServices());
        }
    }
}

