/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.deployment;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CasePlanModel;
import org.camunda.bpm.model.cmmn.instance.Definitions;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class CmmnDeployerTest
extends PluggableProcessEngineTestCase {
    public void testCmmnDeployment() {
        String deploymentId = this.processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn").deploy().getId();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = this.processEngine.getRepositoryService().createCaseDefinitionQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId);
    }

    public void testDeployTwoCasesWithDuplicateIdAtTheSameTime() {
        try {
            String cmmnResourceName1 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
            String cmmnResourceName2 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment2.cmmn";
            this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName1).addClasspathResource(cmmnResourceName2).name("duplicateAtTheSameTime").deploy();
            CmmnDeployerTest.fail();
        }
        catch (Exception e) {
            CmmnDeployerTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png"})
    public void testCaseDiagramResource() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", (String)caseDefinition.getResourceName());
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        String diagramResourceName = caseDefinition.getDiagramResourceName();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png", (String)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(this.deploymentId, "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        CmmnDeployerTest.assertEquals((int)2540, (int)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png"})
    public void testMultipleDiagramResourcesProvided() {
        CaseDefinition caseA = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("a").singleResult();
        CaseDefinition caseB = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("b").singleResult();
        CaseDefinition caseC = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("c").singleResult();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", (String)caseA.getDiagramResourceName());
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", (String)caseB.getDiagramResourceName());
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png", (String)caseC.getDiagramResourceName());
    }

    public void testDeployCmmn10XmlFile() {
        this.verifyCmmnResourceDeployed("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCmmn10XmlFile.cmmn10.xml");
    }

    public void testDeployCmmn11XmlFile() {
        this.verifyCmmnResourceDeployed("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCmmn11XmlFile.cmmn11.xml");
    }

    protected void verifyCmmnResourceDeployed(String resourcePath) {
        String deploymentId = this.processEngine.getRepositoryService().createDeployment().addClasspathResource(resourcePath).deploy().getId();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = this.processEngine.getRepositoryService().createCaseDefinitionQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId);
    }

    public void testDeployCmmnModelInstance() throws Exception {
        CmmnModelInstance modelInstance = CmmnDeployerTest.createCmmnModelInstance();
        this.deploymentWithBuilder(this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance));
        CmmnDeployerTest.assertNotNull((Object)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult());
    }

    protected static CmmnModelInstance createCmmnModelInstance() {
        CmmnModelInstance modelInstance = Cmmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setTargetNamespace("http://camunda.org/examples");
        modelInstance.setDefinitions(definitions);
        Case caseElement = (Case)modelInstance.newInstance(Case.class);
        caseElement.setId("a-case");
        definitions.addChildElement((ModelElementInstance)caseElement);
        CasePlanModel casePlanModel = (CasePlanModel)modelInstance.newInstance(CasePlanModel.class);
        caseElement.setCasePlanModel(casePlanModel);
        Cmmn.writeModelToStream((OutputStream)System.out, (CmmnModelInstance)modelInstance);
        return modelInstance;
    }

    public void testDeployAndGetCaseDefinition() throws Exception {
        CmmnModelInstance modelInstance = CmmnDeployerTest.createCmmnModelInstance();
        DeploymentWithDefinitions deployment = this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance).deployWithResult();
        this.deploymentIds.add(deployment.getId());
        List deployedCaseDefinitions = deployment.getDeployedCaseDefinitions();
        CmmnDeployerTest.assertEquals((int)1, (int)deployedCaseDefinitions.size());
        CmmnDeployerTest.assertNull((Object)deployment.getDeployedProcessDefinitions());
        CmmnDeployerTest.assertNull((Object)deployment.getDeployedDecisionDefinitions());
        CmmnDeployerTest.assertNull((Object)deployment.getDeployedDecisionRequirementsDefinitions());
        CaseDefinition persistedCaseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult();
        CmmnDeployerTest.assertEquals((String)persistedCaseDefinition.getId(), (String)((CaseDefinition)deployedCaseDefinitions.get(0)).getId());
    }

    public void testDeployEmptyCaseDefinition() throws Exception {
        CmmnModelInstance modelInstance = Cmmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setTargetNamespace("http://camunda.org/examples");
        modelInstance.setDefinitions(definitions);
        DeploymentWithDefinitions deployment = this.repositoryService.createDeployment().addModelInstance("foo.cmmn", modelInstance).deployWithResult();
        this.deploymentIds.add(deployment.getId());
        CmmnDeployerTest.assertNull((Object)deployment.getDeployedCaseDefinitions());
        CmmnDeployerTest.assertNull((Object)this.repositoryService.createCaseDefinitionQuery().caseDefinitionResourceName("foo.cmmn").singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithIntegerHistoryTimeToLive.cmmn"})
    public void testDeployCaseDefinitionWithIntegerHistoryTimeToLive() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        Integer historyTimeToLive = caseDefinition.getHistoryTimeToLive();
        CmmnDeployerTest.assertNotNull((Object)historyTimeToLive);
        CmmnDeployerTest.assertEquals((int)historyTimeToLive, (int)5);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithStringHistoryTimeToLive.cmmn"})
    public void testDeployCaseDefinitionWithStringHistoryTimeToLive() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        Integer historyTimeToLive = caseDefinition.getHistoryTimeToLive();
        CmmnDeployerTest.assertNotNull((Object)historyTimeToLive);
        CmmnDeployerTest.assertEquals((int)historyTimeToLive, (int)5);
    }

    public void testDeployCaseDefinitionWithMalformedHistoryTimeToLive() {
        try {
            this.deployment(new String[]{"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testDeployCaseDefinitionWithMalformedHistoryTimeToLive.cmmn"});
            CmmnDeployerTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            CmmnDeployerTest.assertTrue((boolean)e.getCause().getMessage().contains("Cannot parse historyTimeToLive"));
        }
    }
}

