/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.cmmn.operation.TaskWaitState;
import org.junit.Test;

public class CaseExecutionTerminationTest
extends PvmTestCase {
    @Test
    public void testTerminateCaseInstance() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        caseInstance.terminate();
        CaseExecutionTerminationTest.assertTrue((boolean)caseInstance.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)stageX.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)taskB.isTerminated());
    }

    @Test
    public void testTerminateStage() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        stageX.terminate();
        CaseExecutionTerminationTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionTerminationTest.assertTrue((boolean)stageX.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)taskB.isTerminated());
    }

    @Test
    public void testTerminateTask() {
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).property("manualActivationRule", this.defaultManualActivation()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.terminate();
        CaseExecutionTerminationTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionTerminationTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionTerminationTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionTerminationTest.assertTrue((boolean)taskB.isEnabled());
    }
}

