/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.DatabaseHelper;
import org.slf4j.Logger;

public class CompetingTransactionsOptimisticLockingTest
extends PluggableProcessEngineTestCase {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    static ControllableThread activeThread;

    protected void runTest() throws Throwable {
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!"postgres".equals(databaseType)) {
            super.runTest();
        }
    }

    @Deployment
    public void testCompetingTransactionsOptimisticLocking() throws Exception {
        this.runtimeService.startProcessInstanceByKey("competingTransactionsProcess");
        List tasks = this.taskService.createTaskQuery().list();
        CompetingTransactionsOptimisticLockingTest.assertEquals((int)2, (int)tasks.size());
        Task firstTask = "task1-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        Task secondTask = "task2-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        TransactionThread thread1 = new TransactionThread(firstTask.getId());
        thread1.startAndWaitUntilControlIsReturned();
        TransactionThread thread2 = new TransactionThread(secondTask.getId());
        thread2.startAndWaitUntilControlIsReturned();
        thread2.proceedAndWaitTillDone();
        CompetingTransactionsOptimisticLockingTest.assertNull((Object)((Object)thread2.exception));
        thread1.proceedAndWaitTillDone();
        CompetingTransactionsOptimisticLockingTest.assertNotNull((Object)((Object)thread1.exception));
        CompetingTransactionsOptimisticLockingTest.assertEquals(OptimisticLockingException.class, ((Object)((Object)thread1.exception)).getClass());
    }

    public class TransactionThread
    extends ControllableThread {
        String taskId;
        ProcessEngineException exception;

        public TransactionThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingTransactionsOptimisticLockingTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.taskId, null)));
            }
            catch (ProcessEngineException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends.");
        }
    }
}

