/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.cmmn.decisiontask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricDetailQueryTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected CaseService caseService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.caseService = this.engineRule.getCaseService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        this.identityService.setAuthenticatedUserId("demo");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String userOperationId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getUserOperationId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId(userOperationId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.userOperationId(null);
            Assert.fail((String)"It was possible to set a null value as userOperationId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String executionId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getExecutionId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId(executionId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIdAndProcessInstanceId() {
        this.startProcessInstance(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String processInstanceId = task.getProcessInstanceId();
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetail detail = (HistoricDetail)this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).executionId(executionId).singleResult();
        Assert.assertThat((Object)detail.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstanceId));
        Assert.assertThat((Object)detail.getExecutionId(), (Matcher)CoreMatchers.is((Object)executionId));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"string"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricDetail historicDetail = (HistoricDetail)query.list().get(0);
        if (historicDetail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicDetail;
            Assert.assertEquals((Object)variableUpdate.getVariableName(), (Object)"stringVar");
            Assert.assertEquals((Object)variableUpdate.getTypeName(), (Object)"string");
        } else {
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithCapitalLetter() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"Boolean"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricDetail historicDetail = (HistoricDetail)query.list().get(0);
        if (historicDetail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicDetail;
            Assert.assertEquals((Object)variableUpdate.getVariableName(), (Object)"boolVar");
            Assert.assertEquals((Object)variableUpdate.getTypeName(), (Object)"boolean");
        } else {
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithSeveralTypes() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        variables1.put("nullVar", null);
        variables1.put("pojoVar", new TestPojo("str", 0.0));
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"boolean", "integer", "Serializable"});
        Assert.assertEquals((long)3L, (long)query.list().size());
        Assert.assertEquals((long)3L, (long)query.count());
        HashSet<String> allowedVariableTypes = new HashSet<String>();
        allowedVariableTypes.add("boolean");
        allowedVariableTypes.add("integer");
        allowedVariableTypes.add("object");
        for (HistoricDetail detail : query.list()) {
            if (detail instanceof HistoricVariableUpdate) {
                HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
                Assert.assertTrue((boolean)allowedVariableTypes.contains(variableUpdate.getTypeName()));
                continue;
            }
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.variableTypeIn(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.variableTypeIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySingleProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId()});
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)((HistoricDetail)query.list().get(0)).getProcessInstanceId(), (Object)processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySeveralProcessInstanceIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()});
        HashSet<String> expectedProcessInstanceIds = new HashSet<String>();
        expectedProcessInstanceIds.add(processInstance.getId());
        expectedProcessInstanceIds.add(processInstance2.getId());
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)expectedProcessInstanceIds.contains(((HistoricDetail)query.list().get(0)).getProcessInstanceId()));
        Assert.assertTrue((boolean)expectedProcessInstanceIds.contains(((HistoricDetail)query.list().get(1)).getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNonExistingProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().processInstanceIdIn(new String[]{"foo"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidProcessInstanceIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.processInstanceIdIn(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.processInstanceIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)1L, (long)query.occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredBefore(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredAfter() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.occurredAfter(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredAfterAndOccurredBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.occurredAfter(hourAgo.getTime()).occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).occurredBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourAgo.getTime()).occurredBefore(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidOccurredBeforeDate() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.occurredBefore(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidOccurredAfterDate() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.occurredAfter(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceIdAndCaseExecutionId() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        HistoricDetail detail = (HistoricDetail)this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).caseExecutionId(caseInstanceId).singleResult();
        Assert.assertThat((Object)detail.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstanceId));
        Assert.assertThat((Object)detail.getCaseExecutionId(), (Matcher)CoreMatchers.is((Object)caseInstanceId));
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue");
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1);
    }

    protected void startProcessInstances(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.testHelper.executeAvailableJobs();
    }
}

