/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineLoggingRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExceptionLoggingTest {
    private static final String JOBEXECUTOR_LOGGER = "org.camunda.bpm.engine.jobexecutor";
    private static final String CONTEXT_LOGGER = "org.camunda.bpm.engine.context";
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.camunda.bpm.engine.context", "org.camunda.bpm.engine.jobexecutor").level(Level.DEBUG);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.loggingRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getProcessEngine().getRuntimeService();
        this.managementService = this.engineRule.getProcessEngine().getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setDefaultNumberOfRetries(1);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setDefaultNumberOfRetries(3);
        this.processEngineConfiguration.setEnableCmdExceptionLogging(true);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.deleteJob(job.getId());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/delegateThrowsException.bpmn20.xml"})
    public void shouldLogFailingJobOnlyOnceReducedLogging() {
        this.processEngineConfiguration.setEnableCmdExceptionLogging(false);
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        jobExecutor.shutdown();
        List<ILoggingEvent> jobLog = this.loggingRule.getFilteredLog(JOBEXECUTOR_LOGGER, "Exception while executing job");
        List<ILoggingEvent> ctxLog = this.loggingRule.getFilteredLog(CONTEXT_LOGGER, "Exception while closing command context");
        Assertions.assertThat((int)jobLog.size()).isEqualTo(1);
        Assertions.assertThat((int)ctxLog.size()).isEqualTo(0);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/delegateThrowsException.bpmn20.xml"})
    public void shouldLogFailingJobTwiceDefaultLogging() {
        this.processEngineConfiguration.setEnableCmdExceptionLogging(true);
        this.runtimeService.startProcessInstanceByKey("testProcess");
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        jobExecutor.shutdown();
        List<ILoggingEvent> jobLog = this.loggingRule.getFilteredLog(JOBEXECUTOR_LOGGER, "Exception while executing job");
        List<ILoggingEvent> ctxLog = this.loggingRule.getFilteredLog(CONTEXT_LOGGER, "Exception while closing command context");
        Assertions.assertThat((int)jobLog.size()).isEqualTo(1);
        Assertions.assertThat((int)ctxLog.size()).isEqualTo(1);
    }

    @Test
    public void shouldNotLogExceptionWhenApiCallReducedLogging() {
        this.processEngineConfiguration.setEnableCmdExceptionLogging(false);
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingDelegate").startEvent().serviceTask().camundaClass("org.camunda.bpm.engine.test.jobexecutor.FailingDelegate")).camundaAsyncBefore()).done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("failingDelegate");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        RuntimeException expectedException = null;
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        List<ILoggingEvent> jobLog = this.loggingRule.getFilteredLog(JOBEXECUTOR_LOGGER, "Exception while executing job");
        List<ILoggingEvent> ctxLog = this.loggingRule.getFilteredLog(CONTEXT_LOGGER, "Exception while closing command context");
        Assertions.assertThat((Throwable)expectedException).isNotNull();
        Assertions.assertThat((String)expectedException.getMessage()).contains(new CharSequence[]{"Expected Exception"});
        Assertions.assertThat((int)jobLog.size()).isEqualTo(0);
        Assertions.assertThat((int)ctxLog.size()).isEqualTo(0);
    }

    @Test
    public void shouldNotLogExceptionWhenUserApiCallReducedLogging() {
        this.processEngineConfiguration.setEnableCmdExceptionLogging(false);
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingDelegate").startEvent().serviceTask().camundaClass("org.camunda.bpm.engine.test.jobexecutor.FailingDelegate")).done();
        this.testRule.deploy(modelInstance);
        RuntimeException expectedException = null;
        try {
            this.runtimeService.startProcessInstanceByKey("failingDelegate");
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        List<ILoggingEvent> jobLog = this.loggingRule.getFilteredLog(JOBEXECUTOR_LOGGER, "Exception while executing job");
        List<ILoggingEvent> ctxLog = this.loggingRule.getFilteredLog(CONTEXT_LOGGER, "Exception while closing command context");
        Assertions.assertThat((Throwable)expectedException).isNotNull();
        Assertions.assertThat((String)expectedException.getMessage()).contains(new CharSequence[]{"Expected Exception"});
        Assertions.assertThat((int)jobLog.size()).isEqualTo(0);
        Assertions.assertThat((int)ctxLog.size()).isEqualTo(0);
    }
}

