/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.test.WatchLogger;
import org.camunda.bpm.engine.test.util.ProcessEngineLoggingRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ProcessEngineLoggingRuleTest {
    private static final String PERSISTENCE_LOGGER = "org.camunda.bpm.engine.persistence";
    private static final String CONTAINER_INTEGRATION_LOGGER = "org.camunda.bpm.container";
    private static final String PROCESS_APPLICATION_LOGGER = "org.camunda.bpm.application";
    private static final String JOB_EXECUTOR_LOGGER = "org.camunda.bpm.engine.jobexecutor";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.camunda.bpm.engine.persistence", "org.camunda.bpm.container").level(Level.DEBUG).watch("org.camunda.bpm.application", Level.INFO);

    @Test
    public void testWithoutAnnotation() {
        this.logSomethingOnAllLevels();
        List<ILoggingEvent> persistenceLog = this.loggingRule.getLog(PERSISTENCE_LOGGER);
        List<ILoggingEvent> containerLog = this.loggingRule.getLog(CONTAINER_INTEGRATION_LOGGER);
        List<ILoggingEvent> processAppLogger = this.loggingRule.getLog(PROCESS_APPLICATION_LOGGER);
        RuntimeException expectedException = null;
        try {
            List<ILoggingEvent> list = this.loggingRule.getLog(JOB_EXECUTOR_LOGGER);
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        Assert.assertNotNull((Object)expectedException);
        Assert.assertThat((Object)expectedException.getMessage(), (Matcher)Matchers.containsString((String)"not watching any logger with name: "));
        this.testLogLevel(persistenceLog, Level.DEBUG);
        this.testLogLevel(containerLog, Level.DEBUG);
        this.testLogLevel(processAppLogger, Level.INFO);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.container"}, level="WARN")
    public void testOverrideWithAnnotation() {
        this.logSomethingOnAllLevels();
        List<ILoggingEvent> persistenceLog = this.loggingRule.getLog(PERSISTENCE_LOGGER);
        List<ILoggingEvent> containerLog = this.loggingRule.getLog(CONTAINER_INTEGRATION_LOGGER);
        List<ILoggingEvent> processAppLogger = this.loggingRule.getLog(PROCESS_APPLICATION_LOGGER);
        RuntimeException expectedException = null;
        try {
            List<ILoggingEvent> list = this.loggingRule.getLog(JOB_EXECUTOR_LOGGER);
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        Assert.assertNotNull((Object)expectedException);
        Assert.assertThat((Object)expectedException.getMessage(), (Matcher)Matchers.containsString((String)"not watching any logger with name: "));
        this.testLogLevel(persistenceLog, Level.DEBUG);
        this.testLogLevel(containerLog, Level.WARN);
        this.testLogLevel(processAppLogger, Level.INFO);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.jobexecutor"}, level="ERROR")
    public void testAddWatchedLoggerWithAnnotation() {
        this.logSomethingOnAllLevels();
        List<ILoggingEvent> persistenceLog = this.loggingRule.getLog(PERSISTENCE_LOGGER);
        List<ILoggingEvent> containerLog = this.loggingRule.getLog(CONTAINER_INTEGRATION_LOGGER);
        List<ILoggingEvent> processAppLogger = this.loggingRule.getLog(PROCESS_APPLICATION_LOGGER);
        List<ILoggingEvent> jobExecutorLogger = this.loggingRule.getLog(JOB_EXECUTOR_LOGGER);
        this.testLogLevel(persistenceLog, Level.DEBUG);
        this.testLogLevel(containerLog, Level.DEBUG);
        this.testLogLevel(processAppLogger, Level.INFO);
        this.testLogLevel(jobExecutorLogger, Level.ERROR);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.container"}, level="OFF")
    public void testTurnOffWatcherWithAnnotation() {
        this.logSomethingOnAllLevels();
        List<ILoggingEvent> persistenceLog = this.loggingRule.getLog(PERSISTENCE_LOGGER);
        List<ILoggingEvent> containerLog = this.loggingRule.getLog(CONTAINER_INTEGRATION_LOGGER);
        List<ILoggingEvent> processAppLogger = this.loggingRule.getLog(PROCESS_APPLICATION_LOGGER);
        RuntimeException expectedException = null;
        try {
            List<ILoggingEvent> list = this.loggingRule.getLog(JOB_EXECUTOR_LOGGER);
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        Assert.assertNotNull((Object)expectedException);
        Assert.assertThat((Object)expectedException.getMessage(), (Matcher)Matchers.containsString((String)"not watching any logger with name: "));
        this.testLogLevel(persistenceLog, Level.DEBUG);
        this.testLogLevel(processAppLogger, Level.INFO);
        Assert.assertThat((Object)containerLog.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.jobexecutor", "org.camunda.bpm.engine.persistence", "org.camunda.bpm.container", "org.camunda.bpm.application"}, level="DEBUG")
    public void testLogOrder() {
        this.logSomethingOnAllLevels();
        List<ILoggingEvent> fullLog = this.loggingRule.getLog();
        ILoggingEvent previousLogEntry = null;
        for (ILoggingEvent logEntry : fullLog) {
            if (previousLogEntry != null) {
                Assert.assertTrue((previousLogEntry.getTimeStamp() <= logEntry.getTimeStamp() ? 1 : 0) != 0);
            }
            previousLogEntry = logEntry;
        }
    }

    private void testLogLevel(List<ILoggingEvent> log, Level level) {
        this.testAtLeastOneLogEntryWithLevelIsPresent(log, level);
        this.testAllLoggingEntriesAtLeastLevel(log, level);
    }

    private void testAtLeastOneLogEntryWithLevelIsPresent(List<ILoggingEvent> log, Level level) {
        for (ILoggingEvent logEntry : log) {
            if (!logEntry.getLevel().equals(level)) continue;
            return;
        }
        Assert.fail((String)("Expected at least one log entry with level " + level + " in log"));
    }

    private void testAllLoggingEntriesAtLeastLevel(List<ILoggingEvent> log, Level level) {
        for (ILoggingEvent logStatement : log) {
            Assert.assertTrue((boolean)logStatement.getLevel().isGreaterOrEqual(level));
        }
    }

    public void logSomethingOnAllLevels() {
        ProcessEngineLogger.PERSISTENCE_LOGGER.debugJobExecuted(null);
        ProcessEngineLogger.PERSISTENCE_LOGGER.performingDatabaseOperation("test", "test", "test");
        ProcessEngineLogger.PERSISTENCE_LOGGER.removeEntryFromDeploymentCacheFailure("test", "test", new Throwable());
        ProcessEngineLogger.PERSISTENCE_LOGGER.noDeploymentLockPropertyFound();
        ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER.debugAutoCompletedUrl("test");
        ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER.foundConfigJndi("test", "test");
        ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER.exceptionWhileStopping("test", "test", new Throwable());
        ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER.interruptedWhileShuttingDownThreadPool(new InterruptedException());
        ProcessEngineLogger.JOB_EXECUTOR_LOGGER.debugAcquiredJobNotFound("test");
        ProcessEngineLogger.JOB_EXECUTOR_LOGGER.startingUpJobExecutor("test");
        ProcessEngineLogger.JOB_EXECUTOR_LOGGER.warnHistoryCleanupBatchWindowNotFound();
        ProcessEngineLogger.JOB_EXECUTOR_LOGGER.exceptionDuringJobAcquisition(new Exception());
        ProcessEngineLogger.PROCESS_APPLICATION_LOGGER.paDoesNotProvideExecutionListener("test");
        ProcessEngineLogger.PROCESS_APPLICATION_LOGGER.detectedPa(Object.class);
        ProcessEngineLogger.PROCESS_APPLICATION_LOGGER.alreadyDeployed();
        ProcessEngineLogger.PROCESS_APPLICATION_LOGGER.couldNotRemoveDefinitionsFromCache(new Throwable());
    }
}

