/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.identity.IdentityOperationResult;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntryBuilder;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.impl.util.PermissionConverter;
import org.camunda.bpm.engine.impl.util.StringUtil;

public class UserOperationLogManager
extends AbstractHistoricManager {
    public UserOperationLogEntry findOperationLogById(String entryId) {
        return this.getDbEntityManager().selectById(UserOperationLogEntryEventEntity.class, entryId);
    }

    public long findOperationLogEntryCountByQueryCriteria(UserOperationLogQueryImpl query) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectUserOperationLogEntryCountByQueryCriteria", query);
    }

    public List<UserOperationLogEntry> findOperationLogEntriesByQueryCriteria(UserOperationLogQueryImpl query, Page page) {
        this.getAuthorizationManager().configureUserOperationLogQuery(query);
        return this.getDbEntityManager().selectList("selectUserOperationLogEntriesByQueryCriteria", query, page);
    }

    public void addRemovalTimeToUserOperationLogByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(UserOperationLogEntryEventEntity.class, "updateUserOperationLogByRootProcessInstanceId", parameters);
    }

    public void addRemovalTimeToUserOperationLogByProcessInstanceId(String processInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(UserOperationLogEntryEventEntity.class, "updateUserOperationLogByProcessInstanceId", parameters);
    }

    public void updateOperationLogAnnotationByOperationId(String operationId, String annotation) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("operationId", operationId);
        parameters.put("annotation", annotation);
        this.getDbEntityManager().updatePreserveOrder(UserOperationLogEntryEventEntity.class, "updateOperationLogAnnotationByOperationId", parameters);
    }

    public void deleteOperationLogEntryById(String entryId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogEntryById", entryId);
        }
    }

    public DbOperation deleteOperationLogByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(UserOperationLogEntryEventEntity.class, "deleteUserOperationLogByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    public void logUserOperations(UserOperationLogContext context) {
        if (this.isUserOperationLogEnabled()) {
            this.fireUserOperationLog(context);
        }
    }

    public void logUserOperation(IdentityOperationResult operationResult, String userId) {
        this.logUserOperation(this.getOperationType(operationResult), userId);
    }

    public void logUserOperation(String operation, String userId) {
        if (operation != null && this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "User").category("Admin").propertyChanges(new PropertyChange("userId", null, userId));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logGroupOperation(IdentityOperationResult operationResult, String groupId) {
        this.logGroupOperation(this.getOperationType(operationResult), groupId);
    }

    public void logGroupOperation(String operation, String groupId) {
        if (operation != null && this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Group").category("Admin").propertyChanges(new PropertyChange("groupId", null, groupId));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logTenantOperation(IdentityOperationResult operationResult, String tenantId) {
        this.logTenantOperation(this.getOperationType(operationResult), tenantId);
    }

    public void logTenantOperation(String operation, String tenantId) {
        if (operation != null && this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Tenant").category("Admin").propertyChanges(new PropertyChange("tenantId", null, tenantId));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logMembershipOperation(IdentityOperationResult operationResult, String userId, String groupId, String tenantId) {
        this.logMembershipOperation(this.getOperationType(operationResult), userId, groupId, tenantId);
    }

    public void logMembershipOperation(String operation, String userId, String groupId, String tenantId) {
        if (operation != null && this.isUserOperationLogEnabled()) {
            String entityType = tenantId == null ? "Group membership" : "TenantMembership";
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, entityType).category("Admin");
            ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
            if (userId != null) {
                propertyChanges.add(new PropertyChange("userId", null, userId));
            }
            if (groupId != null) {
                propertyChanges.add(new PropertyChange("groupId", null, groupId));
            }
            if (tenantId != null) {
                propertyChanges.add(new PropertyChange("tenantId", null, tenantId));
            }
            entryBuilder.propertyChanges(propertyChanges);
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logTaskOperations(String operation, TaskEntity task, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Task").category("TaskWorker").inContextOf(task, propertyChanges);
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logTaskOperations(String operation, HistoricTaskInstance historicTask, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Task").inContextOf(historicTask, propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logLinkOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "IdentityLink").category("TaskWorker").inContextOf(task, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logProcessInstanceOperation(String operation, List<PropertyChange> propertyChanges) {
        this.logProcessInstanceOperation(operation, null, null, null, propertyChanges);
    }

    public void logProcessInstanceOperation(String operation, String processInstanceId, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "ProcessInstance").propertyChanges(propertyChanges).processInstanceId(processInstanceId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).category("Operator");
            if (processInstanceId != null) {
                ExecutionEntity instance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (instance != null) {
                    entryBuilder.inContextOf(instance);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logProcessDefinitionOperation(String operation, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "ProcessDefinition").propertyChanges(propertyChange).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).category("Operator");
            if (processDefinitionId != null) {
                ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logCaseInstanceOperation(String operation, String caseInstanceId, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "CaseInstance").caseInstanceId(caseInstanceId).propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logCaseDefinitionOperation(String operation, String caseDefinitionId, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "CaseDefinition").propertyChanges(propertyChanges).caseDefinitionId(caseDefinitionId).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logDecisionDefinitionOperation(String operation, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "DecisionDefinition").propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logJobOperation(String operation, String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        this.logJobOperation(operation, jobId, jobDefinitionId, processInstanceId, processDefinitionId, processDefinitionKey, Collections.singletonList(propertyChange));
    }

    public void logJobOperation(String operation, String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Job").jobId(jobId).jobDefinitionId(jobDefinitionId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).propertyChanges(propertyChanges).category("Operator");
            if (jobId != null) {
                JobEntity job = this.getJobManager().findJobById(jobId);
                if (job != null) {
                    entryBuilder.inContextOf(job);
                }
            } else if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    entryBuilder.inContextOf(jobDefinition);
                }
            } else if (processInstanceId != null) {
                ExecutionEntity processInstance = this.getProcessInstanceManager().findExecutionById(processInstanceId);
                if (processInstance != null) {
                    entryBuilder.inContextOf(processInstance);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logJobDefinitionOperation(String operation, String jobDefinitionId, String processDefinitionId, String processDefinitionKey, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            ProcessDefinitionEntity definition;
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "JobDefinition").jobDefinitionId(jobDefinitionId).processDefinitionId(processDefinitionId).processDefinitionKey(processDefinitionKey).propertyChanges(propertyChange).category("Operator");
            if (jobDefinitionId != null) {
                JobDefinitionEntity jobDefinition = this.getJobDefinitionManager().findById(jobDefinitionId);
                if (jobDefinition != null) {
                    entryBuilder.inContextOf(jobDefinition);
                }
            } else if (processDefinitionId != null && (definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId)) != null) {
                entryBuilder.inContextOf(definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logAttachmentOperation(String operation, TaskEntity task, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Attachment").category("TaskWorker").inContextOf(task, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logAttachmentOperation(String operation, ExecutionEntity processInstance, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Attachment").category("TaskWorker").inContextOf(processInstance, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logVariableOperation(String operation, String executionId, String taskId, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Variable").propertyChanges(propertyChange);
            if (executionId != null) {
                ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(executionId);
                entryBuilder.inContextOf(execution).category("Operator");
            } else if (taskId != null) {
                TaskEntity task = this.getTaskManager().findTaskById(taskId);
                entryBuilder.inContextOf(task, Arrays.asList(propertyChange)).category("TaskWorker");
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logHistoricVariableOperation(String operation, HistoricProcessInstanceEntity historicProcessInstance, ResourceDefinitionEntity<?> definition, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Variable").category("Operator").propertyChanges(propertyChange).inContextOf(historicProcessInstance, definition, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logHistoricVariableOperation(String operation, HistoricVariableInstanceEntity historicVariableInstance, ResourceDefinitionEntity<?> definition, PropertyChange propertyChange) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Variable").category("Operator").propertyChanges(propertyChange).inContextOf(historicVariableInstance, definition, Arrays.asList(propertyChange));
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logDeploymentOperation(String operation, String deploymentId, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Deployment").deploymentId(deploymentId).propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logBatchOperation(String operation, List<PropertyChange> propertyChange) {
        this.logBatchOperation(operation, null, propertyChange);
    }

    public void logBatchOperation(String operation, String batchId, PropertyChange propertyChange) {
        this.logBatchOperation(operation, batchId, Collections.singletonList(propertyChange));
    }

    public void logBatchOperation(String operation, String batchId, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Batch").batchId(batchId).propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logDecisionInstanceOperation(String operation, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "DecisionInstance").propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logExternalTaskOperation(String operation, ExternalTaskEntity externalTask, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "ExternalTask").propertyChanges(propertyChanges).category("Operator");
            if (externalTask != null) {
                ExecutionEntity instance = null;
                ProcessDefinitionEntity definition = null;
                if (externalTask.getProcessInstanceId() != null) {
                    instance = this.getProcessInstanceManager().findExecutionById(externalTask.getProcessInstanceId());
                } else if (externalTask.getProcessDefinitionId() != null) {
                    definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(externalTask.getProcessDefinitionId());
                }
                entryBuilder.processInstanceId(externalTask.getProcessInstanceId()).processDefinitionId(externalTask.getProcessDefinitionId()).processDefinitionKey(externalTask.getProcessDefinitionKey()).inContextOf(externalTask, instance, definition);
            }
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logMetricsOperation(String operation, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Metrics").propertyChanges(propertyChanges).category("Operator");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logFilterOperation(String operation, String filterId) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Filter").propertyChanges(new PropertyChange("filterId", null, filterId)).category("TaskWorker");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logPropertyOperation(String operation, List<PropertyChange> propertyChanges) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Property").propertyChanges(propertyChanges).category("Admin");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logSetAnnotationOperation(String operationId) {
        this.logAnnotationOperation(operationId, "SetAnnotation");
    }

    public void logClearAnnotationOperation(String operationId) {
        this.logAnnotationOperation(operationId, "ClearAnnotation");
    }

    protected void logAnnotationOperation(String operationId, String operationType) {
        if (this.isUserOperationLogEnabled()) {
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operationType, "OperationLog").propertyChanges(new PropertyChange("operationId", null, operationId)).category("Operator");
            UserOperationLogContext context = new UserOperationLogContext();
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    public void logAuthorizationOperation(String operation, AuthorizationEntity authorization, AuthorizationEntity previousValues) {
        if (this.isUserOperationLogEnabled()) {
            ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
            propertyChanges.add(new PropertyChange("permissionBits", previousValues == null ? null : Integer.valueOf(previousValues.getPermissions()), authorization.getPermissions()));
            propertyChanges.add(new PropertyChange("permissions", previousValues == null ? null : this.getPermissionStringList(previousValues), this.getPermissionStringList(authorization)));
            propertyChanges.add(new PropertyChange("type", previousValues == null ? null : Integer.valueOf(previousValues.getAuthorizationType()), authorization.getAuthorizationType()));
            propertyChanges.add(new PropertyChange("resource", previousValues == null ? null : this.getResourceName(previousValues.getResourceType()), this.getResourceName(authorization.getResourceType())));
            propertyChanges.add(new PropertyChange("resourceId", previousValues == null ? null : previousValues.getResourceId(), authorization.getResourceId()));
            if (authorization.getUserId() != null || previousValues != null && previousValues.getUserId() != null) {
                propertyChanges.add(new PropertyChange("userId", previousValues == null ? null : previousValues.getUserId(), authorization.getUserId()));
            }
            if (authorization.getGroupId() != null || previousValues != null && previousValues.getGroupId() != null) {
                propertyChanges.add(new PropertyChange("groupId", previousValues == null ? null : previousValues.getGroupId(), authorization.getGroupId()));
            }
            UserOperationLogContext context = new UserOperationLogContext();
            UserOperationLogContextEntryBuilder entryBuilder = UserOperationLogContextEntryBuilder.entry(operation, "Authorization").propertyChanges(propertyChanges).category("Admin");
            context.addEntry(entryBuilder.create());
            this.fireUserOperationLog(context);
        }
    }

    protected String getPermissionStringList(AuthorizationEntity authorization) {
        Permission[] permissionsForResource = Context.getProcessEngineConfiguration().getPermissionProvider().getPermissionsForResource(authorization.getResourceType());
        Permission[] permissions = authorization.getPermissions(permissionsForResource);
        String[] namesForPermissions = PermissionConverter.getNamesForPermissions(authorization, permissions);
        if (namesForPermissions.length == 0) {
            return Permissions.NONE.getName();
        }
        return StringUtil.trimToMaximumLengthAllowed(StringUtil.join(Arrays.asList(namesForPermissions).iterator()));
    }

    protected String getResourceName(int resourceType) {
        return Context.getProcessEngineConfiguration().getPermissionProvider().getNameForResource(resourceType);
    }

    public boolean isUserOperationLogEnabled() {
        return this.isHistoryEventProduced() && (this.isUserOperationLogEnabledOnCommandContext() && this.isUserAuthenticated() || !this.writeUserOperationLogOnlyWithLoggedInUser());
    }

    protected boolean isHistoryEventProduced() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        return historyLevel.isHistoryEventProduced(HistoryEventTypes.USER_OPERATION_LOG, null);
    }

    protected boolean isUserAuthenticated() {
        String userId = this.getAuthenticatedUserId();
        return userId != null && !userId.isEmpty();
    }

    protected String getAuthenticatedUserId() {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getAuthenticatedUserId();
    }

    protected void fireUserOperationLog(final UserOperationLogContext context) {
        if (context.getUserId() == null) {
            context.setUserId(this.getAuthenticatedUserId());
        }
        HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

            @Override
            public List<HistoryEvent> createHistoryEvents(HistoryEventProducer producer) {
                return producer.createUserOperationLogEvents(context);
            }
        });
    }

    protected boolean writeUserOperationLogOnlyWithLoggedInUser() {
        return Context.getCommandContext().isRestrictUserOperationLogToAuthenticatedUsers();
    }

    protected boolean isUserOperationLogEnabledOnCommandContext() {
        return Context.getCommandContext().isUserOperationLogEnabled();
    }

    protected String getOperationType(IdentityOperationResult operationResult) {
        switch (operationResult.getOperation()) {
            case "create": {
                return "Create";
            }
            case "update": {
                return "Update";
            }
            case "delete": {
                return "Delete";
            }
            case "unlock": {
                return "Unlock";
            }
        }
        return null;
    }
}

