/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.HashSet;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.util.ResourceTypeUtil;
import org.junit.Test;

public class PermissionsTest {
    @Test
    public void testNewPermissionsIntegrityToOld() {
        for (Permissions permission : Permissions.values()) {
            String permissionName = permission.getName();
            for (Resource resource : permission.getTypes()) {
                Class clazz = (Class)ResourceTypeUtil.getPermissionEnums().get(resource.resourceType());
                if (clazz == null || clazz.equals(Permissions.class)) continue;
                Permission resolvedPermission = null;
                for (Enum enumCandidate : (Enum[])clazz.getEnumConstants()) {
                    if (!enumCandidate.toString().equals(permissionName)) continue;
                    resolvedPermission = (Permission)enumCandidate;
                    break;
                }
                ((AbstractObjectAssert)Assertions.assertThat(resolvedPermission).overridingErrorMessage("Permission %s for resource %s not found in new enum %s", new Object[]{permission, resource, clazz.getSimpleName()})).isNotNull();
                Assertions.assertThat((int)resolvedPermission.getValue()).isEqualTo(permission.getValue());
            }
        }
    }

    @Test
    public void testPermissionsValues() {
        this.verifyValuesAreUniqueAndPowerOfTwo((Permission[])Permissions.values(), Permissions.class.getSimpleName());
    }

    @Test
    public void testRestOfPermissionsEnumValues() {
        for (Class permissionsClass : ResourceTypeUtil.getPermissionEnums().values()) {
            if (permissionsClass.equals(Permissions.class)) continue;
            this.verifyValuesAreUniqueAndPowerOfTwo((Permission[])permissionsClass.getEnumConstants(), permissionsClass.getSimpleName());
        }
    }

    private void verifyValuesAreUniqueAndPowerOfTwo(Permission[] permissions, String className) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (Permission permission : permissions) {
            int value = permission.getValue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)values.add(value)).overridingErrorMessage("The value '%s' of '%s' permission is not unique for '%s' permission enum. Another permission already has this value.", new Object[]{value, permission, className})).isTrue();
            if (value == Integer.MAX_VALUE || value == 0) continue;
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isPowerOfTwo(value)).overridingErrorMessage("The value '%s' of '%s' permission is invalid for '%s' permission enum. The values must be power of 2.", new Object[]{value, permission, className})).isTrue();
        }
    }

    private boolean isPowerOfTwo(int value) {
        return value > 1 && (value & value - 1) == 0;
    }
}

