/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestUtil;
import org.camunda.bpm.engine.test.api.authorization.util.MissingAuthorizationMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class AuthorizationScenarioInstance {
    protected AuthorizationScenario scenario;
    protected List<Authorization> createdAuthorizations = new ArrayList<Authorization>();
    protected List<Authorization> missingAuthorizations = new ArrayList<Authorization>();

    public AuthorizationScenarioInstance(AuthorizationScenario scenario, AuthorizationService authorizationService, Map<String, String> resourceBindings) {
        this.scenario = scenario;
        this.init(authorizationService, resourceBindings);
    }

    public void init(AuthorizationService authorizationService, Map<String, String> resourceBindings) {
        Authorization authorization;
        for (AuthorizationSpec authorizationSpec : this.scenario.getGivenAuthorizations()) {
            authorization = authorizationSpec.instantiate(authorizationService, resourceBindings);
            authorizationService.saveAuthorization(authorization);
            this.createdAuthorizations.add(authorization);
        }
        for (AuthorizationSpec authorizationSpec : this.scenario.getMissingAuthorizations()) {
            authorization = authorizationSpec.instantiate(authorizationService, resourceBindings);
            this.missingAuthorizations.add(authorization);
        }
    }

    public void tearDown(AuthorizationService authorizationService) {
        HashSet<String> activeAuthorizations = new HashSet<String>();
        for (Authorization activeAuthorization : authorizationService.createAuthorizationQuery().list()) {
            activeAuthorizations.add(activeAuthorization.getId());
        }
        for (Authorization createdAuthorization : this.createdAuthorizations) {
            if (!activeAuthorizations.contains(createdAuthorization.getId())) continue;
            authorizationService.deleteAuthorization(createdAuthorization.getId());
        }
    }

    public void assertAuthorizationException(AuthorizationException e) {
        if (!this.missingAuthorizations.isEmpty() && e != null) {
            String message = e.getMessage();
            String assertionFailureMessage = this.describeScenarioFailure("Expected an authorization exception but the message was wrong: " + e.getMessage());
            ArrayList actualMissingAuthorizations = new ArrayList(e.getMissingAuthorizations());
            List<MissingAuthorization> expectedMissingAuthorizations = MissingAuthorizationMatcher.asMissingAuthorizations(this.missingAuthorizations);
            Assert.assertThat(actualMissingAuthorizations, (Matcher)Matchers.containsInAnyOrder(MissingAuthorizationMatcher.asMatchers(expectedMissingAuthorizations)));
            for (Authorization missingAuthorization : this.missingAuthorizations) {
                Permission[] permissions;
                Assert.assertTrue((String)assertionFailureMessage, (boolean)message.contains(missingAuthorization.getUserId()));
                Assert.assertEquals((Object)missingAuthorization.getUserId(), (Object)e.getUserId());
                for (Permission permission : permissions = AuthorizationTestUtil.getPermissions(missingAuthorization)) {
                    if (permission.getValue() == Permissions.NONE.getValue()) continue;
                    Assert.assertTrue((String)assertionFailureMessage, (boolean)message.contains(permission.getName()));
                    break;
                }
                if (!"*".equals(missingAuthorization.getResourceId())) {
                    Assert.assertTrue((String)assertionFailureMessage, (boolean)message.contains(missingAuthorization.getResourceId()));
                }
                Resource resource = AuthorizationTestUtil.getResourceByType(missingAuthorization.getResourceType());
                Assert.assertTrue((String)assertionFailureMessage, (boolean)message.contains(resource.resourceName()));
            }
        } else if (!this.missingAuthorizations.isEmpty() || e != null) {
            if (e != null) {
                Assert.fail((String)this.describeScenarioFailure("Expected no authorization exception but got one: " + e.getMessage()));
            } else {
                Assert.fail((String)this.describeScenarioFailure("Expected failure due to missing authorizations but code under test was successful"));
            }
        }
    }

    protected String describeScenarioFailure(String message) {
        return message + "\n\nScenario: \n" + this.scenario.toString();
    }
}

