/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceCaseInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    public void testCreateByInvalidKey() {
        try {
            this.caseService.withCaseDefinitionByKey("invalid").create();
            CaseServiceCaseInstanceTest.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseDefinitionByKey(null).create();
            CaseServiceCaseInstanceTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateById() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    public void testCreateByInvalidId() {
        try {
            this.caseService.withCaseDefinition("invalid").create();
            CaseServiceCaseInstanceTest.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseDefinition(null).create();
            CaseServiceCaseInstanceTest.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").businessKey("aBusinessKey").create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).businessKey("aBusinessKey").create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithVariable() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceCaseInstanceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseInstanceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceCaseInstanceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariables(variables).create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceCaseInstanceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseInstanceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceCaseInstanceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceCaseInstanceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseInstanceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceCaseInstanceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).setVariables(variables).create();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceCaseInstanceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceCaseInstanceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceCaseInstanceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceCaseInstanceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceCaseInstanceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).manualStart();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to start a case instance manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDisable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).disable();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to disable a case instance.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).reenable();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to re-enable a case instance.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testCompleteWithEnabledTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceCaseInstanceTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteWithEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).complete();
        this.caseService.withCaseExecution(caseExecution2.getId()).complete();
        CaseExecution caseExecution3 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceCaseInstanceTest.assertNull((Object)caseExecution3);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteWithActiveTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).complete();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseExecution);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseExecution.isActive());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteWithActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).complete();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to complete a case instance containing an active stage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseExecution);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseExecution.isActive());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyCasePlanModelCase.cmmn"})
    public void testAutoCompletionOfEmptyCase() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCloseAnActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).close();
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to close an active case instance.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testCloseACompletedCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseInstanceId).close();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseServiceCaseInstanceTest.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceCaseInstanceTest.assertTrue((boolean)taskExecution.isActive());
        this.caseService.withCaseExecution(caseInstanceId).terminate();
        CaseExecution caseInstance = this.queryCaseExecutionByActivityId("CasePlanModel_1");
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isTerminated());
        CaseServiceCaseInstanceTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testTerminateNonActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseServiceCaseInstanceTest.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceCaseInstanceTest.assertTrue((boolean)taskExecution.isEnabled());
        this.caseService.completeCaseExecution(caseInstanceId);
        try {
            this.caseService.terminateCaseExecution(caseInstanceId);
            CaseServiceCaseInstanceTest.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            CaseServiceCaseInstanceTest.assertTrue((boolean)result);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateActiveCaseInstanceNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseServiceCaseInstanceTest.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceCaseInstanceTest.assertTrue((boolean)taskExecution.isActive());
        this.caseService.terminateCaseExecution(caseInstanceId);
        CaseExecution caseInstance = this.queryCaseExecutionByActivityId("CasePlanModel_1");
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isTerminated());
        CaseServiceCaseInstanceTest.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId);
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", "aBusinessKey");
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, "aBusinessKey");
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceCaseInstanceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceCaseInstanceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithVariablesNonFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", variables);
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)variable);
        CaseServiceCaseInstanceTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceCaseInstanceTest.assertEquals((Object)"aValue", (Object)variable.getValue());
        CaseServiceCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)variable.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithVariablesNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).singleResult();
        CaseServiceCaseInstanceTest.assertNotNull((Object)variable);
        CaseServiceCaseInstanceTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceCaseInstanceTest.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByKeyWithVariablesAndBusinessKeyNonFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", "aBusinessKey", variables);
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateByIdWithVariablesAndBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, "aBusinessKey", variables);
        CaseServiceCaseInstanceTest.assertNotNull((Object)caseInstance);
        CaseServiceCaseInstanceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceCaseInstanceTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testCloseNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.closeCaseInstance(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceCaseInstanceTest.assertNull((Object)caseInstance);
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }
}

