/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class PasswordPolicyConfigurationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setPasswordPolicy(null).setEnablePasswordPolicy(false);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setPasswordPolicy(null).setEnablePasswordPolicy(false);
    }

    @Test
    public void testInitialConfiguration() {
        this.processEngineConfiguration.initPasswordPolicy();
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.getPasswordPolicy(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.isEnablePasswordPolicy(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAutoConfigurationDefaultPasswordPolicy() {
        this.processEngineConfiguration.setEnablePasswordPolicy(true);
        this.processEngineConfiguration.initPasswordPolicy();
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.isEnablePasswordPolicy(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.getPasswordPolicy(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DefaultPasswordPolicyImpl.class)));
    }

    @Test
    public void testFullPasswordPolicyConfiguration() {
        this.processEngineConfiguration.setEnablePasswordPolicy(true);
        this.processEngineConfiguration.setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl());
        this.processEngineConfiguration.initPasswordPolicy();
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.isEnablePasswordPolicy(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.processEngineConfiguration.getPasswordPolicy(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DefaultPasswordPolicyImpl.class)));
    }
}

