/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMigrationTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void cannotCreateMigrationPlanBetweenDifferentTenants() {
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_TWO, ProcessModels.ONE_TASK_PROCESS);
        try {
            this.engineRule.getRuntimeService().createMigrationPlan(tenant1Definition.getId(), tenant2Definition.getId()).mapEqualActivities().build();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot migrate process instances between processes of different tenants ('tenant1' != 'tenant2')"));
        }
    }

    @Test
    public void canCreateMigrationPlanFromTenantToNoTenant() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenantDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(tenantDefinition.getId(), sharedDefinition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void canCreateMigrationPlanFromNoTenantToTenant() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenantDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sharedDefinition.getId(), tenantDefinition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void canCreateMigrationPlanForNoTenants() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sharedDefinition.getId(), sharedDefinition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void canMigrateInstanceBetweenSameTenantCase1() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    @Test
    public void cannotMigrateInstanceWithoutTenantIdToDifferentTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        try {
            this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot migrate process instance '" + processInstance.getId() + "' without tenant to a process definition with a tenant ('tenant1')")));
        }
    }

    @Test
    public void canMigrateInstanceWithTenantIdToDefinitionWithoutTenantId() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    protected void assertMigratedTo(ProcessInstance processInstance, ProcessDefinition targetDefinition) {
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance.getId()).processDefinitionId(targetDefinition.getId()).count());
    }
}

