/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class SubTaskQueryTest
extends PluggableProcessEngineTestCase {
    private List<String> taskIds;

    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.taskIds = this.generateTestSubTasks();
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
        this.taskService.deleteTasks(this.taskIds, true);
    }

    public void testQueryExcludeSubtasks() throws Exception {
        TaskQuery query = this.taskService.createTaskQuery();
        SubTaskQueryTest.assertEquals((long)10L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)10, (int)query.list().size());
        query = this.taskService.createTaskQuery().excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)3L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)3, (int)query.list().size());
    }

    public void testQueryWithPagination() throws Exception {
        TaskQuery query = this.taskService.createTaskQuery();
        SubTaskQueryTest.assertEquals((long)10L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        query = this.taskService.createTaskQuery().excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)3L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(0, 1).size());
    }

    public void testQueryExcludeSubtasksSorted() throws Exception {
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().asc();
        SubTaskQueryTest.assertEquals((long)10L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)10, (int)query.list().size());
        query = (TaskQuery)this.taskService.createTaskQuery().excludeSubtasks().orderByTaskAssignee().desc();
        SubTaskQueryTest.assertEquals((long)3L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)3, (int)query.list().size());
    }

    public void testQueryByAssigneeExcludeSubtasks() throws Exception {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo");
        SubTaskQueryTest.assertEquals((long)7L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)7, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskAssignee("gonzo").excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)2L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)2, (int)query.list().size());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.list().size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit").excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.list().size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeExcludeSubtasksPaginated() throws Exception {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo");
        SubTaskQueryTest.assertEquals((long)7L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        query = this.taskService.createTaskQuery().taskAssignee("gonzo").excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)2L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(0, 1).size());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.listPage(0, 2).size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit").excludeSubtasks();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.listPage(0, 2).size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeExcludeSubtasksOrdered() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("gonzo").orderByTaskCreateTime().desc();
        SubTaskQueryTest.assertEquals((long)7L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)7, (int)query.list().size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("02/01/2009 01:01:01.000"), (Object)((Task)query.list().get(0)).getCreateTime());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("gonzo").excludeSubtasks().orderByTaskCreateTime().asc();
        SubTaskQueryTest.assertEquals((long)2L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)2, (int)query.list().size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("01/02/2008 02:02:02.000"), (Object)((Task)query.list().get(0)).getCreateTime());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("05/02/2008 02:02:02.000"), (Object)((Task)query.list().get(1)).getCreateTime());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("kermit").orderByTaskCreateTime().asc();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.list().size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("kermit").excludeSubtasks().orderByTaskCreateTime().desc();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.list().size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
    }

    public void testQueryByAssigneeExcludeSubtasksOrderedAndPaginated() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("gonzo").orderByTaskCreateTime().asc();
        SubTaskQueryTest.assertEquals((long)7L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(0, 1).size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("01/02/2008 02:02:02.000"), (Object)((Task)query.listPage(0, 1).get(0)).getCreateTime());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(1, 1).size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("05/02/2008 02:02:02.000"), (Object)((Task)query.listPage(1, 1).get(0)).getCreateTime());
        SubTaskQueryTest.assertEquals((int)2, (int)query.listPage(0, 2).size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("01/02/2008 02:02:02.000"), (Object)((Task)query.listPage(0, 2).get(0)).getCreateTime());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("05/02/2008 02:02:02.000"), (Object)((Task)query.listPage(0, 2).get(1)).getCreateTime());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("gonzo").excludeSubtasks().orderByTaskCreateTime().desc();
        SubTaskQueryTest.assertEquals((long)2L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(1, 1).size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("01/02/2008 02:02:02.000"), (Object)((Task)query.listPage(1, 1).get(0)).getCreateTime());
        SubTaskQueryTest.assertEquals((int)1, (int)query.listPage(0, 1).size());
        SubTaskQueryTest.assertEquals((Object)sdf.parse("05/02/2008 02:02:02.000"), (Object)((Task)query.listPage(0, 1).get(0)).getCreateTime());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("kermit").orderByTaskCreateTime().asc();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.listPage(0, 2).size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
        query = (TaskQuery)this.taskService.createTaskQuery().taskAssignee("kermit").excludeSubtasks().orderByTaskCreateTime().desc();
        SubTaskQueryTest.assertEquals((long)0L, (long)query.count());
        SubTaskQueryTest.assertEquals((int)0, (int)query.listPage(0, 2).size());
        SubTaskQueryTest.assertNull((Object)query.singleResult());
    }

    private List<String> generateTestSubTasks() throws Exception {
        Task subtask;
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2008 01:01:01.000"));
        Task rootTask1 = this.taskService.newTask();
        rootTask1.setName("rootTestTask");
        rootTask1.setDescription("rootTestTask description");
        this.taskService.saveTask(rootTask1);
        ids.add(rootTask1.getId());
        this.taskService.addCandidateUser(rootTask1.getId(), "kermit");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2009 01:01:01.000"));
        for (int i2 = 1; i2 <= 2; ++i2) {
            Task subtask2 = this.taskService.newTask();
            subtask2.setName("kermitSubTask" + i2);
            subtask2.setParentTaskId(rootTask1.getId());
            subtask2.setDescription("description for kermit sub-task" + i2);
            this.taskService.saveTask(subtask2);
            this.taskService.addCandidateUser(subtask2.getId(), "kermit");
            ids.add(subtask2.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("01/02/2008 02:02:02.000"));
        Task rootTask2 = this.taskService.newTask();
        rootTask2.setName("gonzoRootTask1");
        rootTask2.setDescription("gonzo Root task1 description");
        this.taskService.saveTask(rootTask2);
        this.taskService.setAssignee(rootTask2.getId(), "gonzo");
        ids.add(rootTask2.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("05/02/2008 02:02:02.000"));
        Task rootTask3 = this.taskService.newTask();
        rootTask3.setName("gonzoRootTask2");
        rootTask3.setDescription("gonzo Root task2 description");
        this.taskService.saveTask(rootTask3);
        this.taskService.setAssignee(rootTask3.getId(), "gonzo");
        ids.add(rootTask3.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2009 01:01:01.000"));
        for (i = 1; i <= 3; ++i) {
            subtask = this.taskService.newTask();
            subtask.setName("gonzoSubTask1_" + i);
            subtask.setParentTaskId(rootTask2.getId());
            subtask.setDescription("description for gonzo sub-task1_" + i);
            this.taskService.saveTask(subtask);
            this.taskService.setAssignee(subtask.getId(), "gonzo");
            ids.add(subtask.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("02/01/2009 01:01:01.000"));
        for (i = 1; i <= 2; ++i) {
            subtask = this.taskService.newTask();
            subtask.setName("gonzoSubTask2_" + i);
            subtask.setParentTaskId(rootTask3.getId());
            subtask.setDescription("description for gonzo sub-task2_" + i);
            this.taskService.saveTask(subtask);
            this.taskService.setAssignee(subtask.getId(), "gonzo");
            ids.add(subtask.getId());
        }
        return ids;
    }
}

