/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;

public class CompetingHistoryCleanupAcquisitionTest
extends ConcurrencyTestCase {
    protected final Date CURRENT_DATE = new Date(1363608000000L);
    protected static ConcurrencyTestCase.ThreadControl cleanupThread = null;
    protected static ThreadLocal<Boolean> syncBeforeFlush = new ThreadLocal();
    protected ControllableJobExecutor jobExecutor = new ControllableJobExecutor();
    protected ConcurrencyTestCase.ThreadControl acquisitionThread;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        this.acquisitionThread.reportInterrupts();
        ClockUtil.setCurrentTime((Date)this.CURRENT_DATE);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.jobExecutor.isActive()) {
            this.jobExecutor.shutdown();
        }
        this.jobExecutor.resetOleThrown();
        this.clearDatabase();
        ClockUtil.reset();
        super.tearDown();
    }

    public void testAcquiringEverLivingJobSucceeds() {
        this.jobExecutor.indicateOptimisticLockingException();
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.lockEverLivingJob(jobId);
        cleanupThread = this.executeControllableCommand(new CleanupThread(jobId));
        cleanupThread.waitForSync();
        cleanupThread.makeContinueAndWaitForSync();
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        cleanupThread.makeContinue();
        cleanupThread.join();
        this.acquisitionThread.makeContinueAndWaitForSync();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)this.CURRENT_DATE, (int)10));
        Assertions.assertThat((boolean)this.jobExecutor.isOleThrown()).isFalse();
    }

    public void testReschedulingEverLivingJobSucceeds() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.lockEverLivingJob(jobId);
        cleanupThread = this.executeControllableCommand(new CleanupThread(jobId));
        cleanupThread.waitForSync();
        cleanupThread.makeContinueAndWaitForSync();
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        cleanupThread.makeContinue();
        cleanupThread.join();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)this.CURRENT_DATE, (int)10));
    }

    protected void initializeProcessEngine() {
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        this.jobExecutor.setMaxJobsPerAcquisition(1);
        this.processEngineConfiguration.setJobExecutor((JobExecutor)this.jobExecutor);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("12:00");
        this.processEngineConfiguration.setCustomPostCommandInterceptorsTxRequiresNew(Collections.singletonList(new CommandInterceptor(){

            public <T> T execute(Command<T> command) {
                Object executed = this.next.execute(command);
                if (syncBeforeFlush.get() != null && syncBeforeFlush.get().booleanValue()) {
                    cleanupThread.sync();
                }
                return (T)executed;
            }
        }));
        this.processEngine = this.processEngineConfiguration.buildProcessEngine();
    }

    protected void clearDatabase() {
        this.deleteHistoryCleanupJobs();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("history-cleanup");
                return null;
            }
        });
    }

    protected void lockEverLivingJob(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                job.setLockOwner("foo");
                job.setLockExpirationTime(DateUtils.addDays((Date)CompetingHistoryCleanupAcquisitionTest.this.CURRENT_DATE, (int)10));
                return null;
            }
        });
    }

    public class CleanupThread
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String jobId;

        protected CleanupThread(String jobId) {
            this.jobId = jobId;
        }

        public Void execute(CommandContext commandContext) {
            syncBeforeFlush.set(true);
            CompetingHistoryCleanupAcquisitionTest.this.managementService.executeJob(this.jobId);
            return null;
        }
    }
}

