/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency.partitioning;

import java.util.Map;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class CompetingHistoricByteArrayPartitioningTest
extends AbstractPartitioningTest {
    protected final String VARIABLE_NAME = "aVariableName";
    protected final String VARIABLE_VALUE = "aVariableValue";
    protected final String ANOTHER_VARIABLE_VALUE = "anotherVariableValue";

    public void testConcurrentFetchAndDelete() {
        final String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK, (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.byteArrayValue((byte[])"aVariableValue".getBytes()))).getId();
        final String[] historicByteArrayId = new String[1];
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(processInstanceId);
                VariableInstanceEntity varInstance = (VariableInstanceEntity)execution.getVariableInstance("aVariableName");
                HistoricVariableInstanceEntity historicVariableInstance = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceByVariableInstanceId(varInstance.getId());
                historicByteArrayId[0] = historicVariableInstance.getByteArrayValueId();
                return null;
            }
        });
        ConcurrencyTestCase.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(processInstanceId, historicByteArrayId[0]));
        asyncThread.waitForSync();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getByteArrayManager().deleteByteArrayById(historicByteArrayId[0]);
                return null;
            }
        });
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                MatcherAssert.assertThat((Object)commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, historicByteArrayId[0]), (Matcher)CoreMatchers.nullValue());
                return null;
            }
        });
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        MatcherAssert.assertThat((Object)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getName(), (Matcher)CoreMatchers.is((Object)"aVariableName"));
        MatcherAssert.assertThat((Object)new String((byte[])((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getValue()), (Matcher)CoreMatchers.is((Object)"anotherVariableValue"));
    }

    public class AsyncThread
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        String processInstanceId;
        String historicByteArrayId;

        AsyncThread(String processInstanceId, String historicByteArrayId) {
            this.processInstanceId = processInstanceId;
            this.historicByteArrayId = historicByteArrayId;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, this.historicByteArrayId);
            this.monitor.sync();
            CompetingHistoricByteArrayPartitioningTest.this.runtimeService.setVariable(this.processInstanceId, "aVariableName", (Object)Variables.byteArrayValue((byte[])"anotherVariableValue".getBytes()));
            return null;
        }
    }
}

