/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;

public class UserOperationLogTaskServiceAndBeanTest
extends AbstractUserOperationLogTest {
    protected Task task;

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.task != null) {
            this.taskService.deleteTask(this.task.getId(), true);
        }
    }

    public void testBeanPropertyChanges() {
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("icke");
        Map changes = entity.getPropertyChanges();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((int)1, (int)changes.size());
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setAssignee("er");
        changes = entity.getPropertyChanges();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((int)1, (int)changes.size());
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setDueDate(new Date());
        changes = entity.getPropertyChanges();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((int)2, (int)changes.size());
    }

    public void testNotTrackChangeToTheSameValue() {
        TaskEntity entity = new TaskEntity();
        entity.setPriority(entity.getPriority());
        entity.setOwner(entity.getOwner());
        entity.setFollowUpDate(entity.getFollowUpDate());
        UserOperationLogTaskServiceAndBeanTest.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    public void testRemoveChangeWhenSetBackToTheOrgValue() {
        TaskEntity entity = new TaskEntity();
        entity.setOwner("icke");
        UserOperationLogTaskServiceAndBeanTest.assertFalse((boolean)entity.getPropertyChanges().isEmpty());
        entity.setOwner(null);
        UserOperationLogTaskServiceAndBeanTest.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    public void testAllTrackedProperties() {
        Date yesterday = new Date(new Date().getTime() - 86400000L);
        Date tomorrow = new Date(new Date().getTime() + 86400000L);
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("er");
        entity.setDelegationState(DelegationState.PENDING);
        entity.setDeleted(true);
        entity.setDescription("a description");
        entity.setDueDate(tomorrow);
        entity.setFollowUpDate(yesterday);
        entity.setName("to do");
        entity.setOwner("icke");
        entity.setParentTaskId("parent");
        entity.setPriority(73);
        Map changes = entity.getPropertyChanges();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertSame((Object)DelegationState.PENDING, (Object)((PropertyChange)changes.get("delegation")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertTrue((boolean)((Boolean)((PropertyChange)changes.get("delete")).getNewValue()));
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"a description", (Object)((PropertyChange)changes.get("description")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)tomorrow, (Object)((PropertyChange)changes.get("dueDate")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)yesterday, (Object)((PropertyChange)changes.get("followUpDate")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"to do", (Object)((PropertyChange)changes.get("name")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("owner")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)"parent", (Object)((PropertyChange)changes.get("parentTask")).getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((Object)73, (Object)((PropertyChange)changes.get("priority")).getNewValue());
    }

    public void testDeleteTask() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.taskService.deleteTask(this.task.getId(), "duplicated");
        UserOperationLogQuery query = this.queryOperationDetails("Delete");
        UserOperationLogTaskServiceAndBeanTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry delete = (UserOperationLogEntry)query.singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"delete", (String)delete.getProperty());
        UserOperationLogTaskServiceAndBeanTest.assertFalse((boolean)Boolean.parseBoolean(delete.getOrgValue()));
        UserOperationLogTaskServiceAndBeanTest.assertTrue((boolean)Boolean.parseBoolean(delete.getNewValue()));
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"TaskWorker", (String)delete.getCategory());
    }

    public void testCompositeBeanInteraction() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        UserOperationLogQuery query = this.queryOperationDetails("Create");
        UserOperationLogEntry create = (UserOperationLogEntry)query.singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertNotNull((Object)create);
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"Task", (String)create.getEntityType());
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)create.getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)create.getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)create.getProperty());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"TaskWorker", (String)create.getCategory());
        this.task.setAssignee("icke");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        List entries = this.queryOperationDetails("Update").list();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((int)2, (int)entries.size());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)((UserOperationLogEntry)entries.get(0)).getOperationId(), (String)((UserOperationLogEntry)entries.get(1)).getOperationId());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"TaskWorker", (String)((UserOperationLogEntry)entries.get(0)).getCategory());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"TaskWorker", (String)((UserOperationLogEntry)entries.get(1)).getCategory());
    }

    public void testMultipleValueChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setName("a task");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"to do", (String)update.getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"TaskWorker", (String)update.getCategory());
    }

    public void testSetDateProperty() {
        this.task = this.taskService.newTask();
        Date now = ClockUtil.getCurrentTime();
        this.task.setDueDate(now);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)String.valueOf(now.getTime()), (String)logEntry.getNewValue());
    }

    public void testResetChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        String name = "a task";
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)name, (String)update.getNewValue());
        this.task.setName("to do 1");
        this.task.setName("to do 2");
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)name, (String)update.getNewValue());
    }

    public void testConcurrentTaskChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setAssignee("icke");
        this.taskService.setAssignee(this.task.getId(), "er");
        try {
            this.taskService.saveTask(this.task);
        }
        catch (Exception e) {
            UserOperationLogTaskServiceAndBeanTest.assertNotNull((Object)e);
        }
    }

    public void testCaseInstanceId() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        UserOperationLogQuery query = this.queryOperationDetails("Update");
        UserOperationLogTaskServiceAndBeanTest.assertEquals((long)0L, (long)query.count());
        this.task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(this.task);
        UserOperationLogTaskServiceAndBeanTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        UserOperationLogTaskServiceAndBeanTest.assertNotNull((Object)entry);
        UserOperationLogTaskServiceAndBeanTest.assertNull((Object)entry.getOrgValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"aCaseInstanceId", (String)entry.getNewValue());
        UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"caseInstanceId", (String)entry.getProperty());
        this.task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(this.task);
        UserOperationLogTaskServiceAndBeanTest.assertEquals((long)2L, (long)query.count());
        List entries = query.list();
        UserOperationLogTaskServiceAndBeanTest.assertEquals((int)2, (int)entries.size());
        for (UserOperationLogEntry currentEntry : entries) {
            if (currentEntry.getId().equals(entry.getId())) continue;
            UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"aCaseInstanceId", (String)currentEntry.getOrgValue());
            UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"anotherCaseInstanceId", (String)currentEntry.getNewValue());
            UserOperationLogTaskServiceAndBeanTest.assertEquals((String)"caseInstanceId", (String)currentEntry.getProperty());
        }
    }

    private UserOperationLogQuery queryOperationDetails(String type) {
        return this.historyService.createUserOperationLogQuery().operationType(type);
    }
}

