/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.identity;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.identity.PasswordPolicyResult;
import org.camunda.bpm.engine.identity.PasswordPolicyRule;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyDigitRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyLengthRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyLowerCaseRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicySpecialCharacterRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyUpperCaseRuleImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultPasswordPolicyTest {
    @Rule
    public ProcessEngineRule rule = new ProcessEngineRule(true);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected IdentityService identityService;
    protected PasswordPolicy policy = new DefaultPasswordPolicyImpl();

    @Before
    public void init() {
        this.identityService = this.rule.getIdentityService();
        this.rule.getProcessEngineConfiguration().setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl()).setEnablePasswordPolicy(true);
    }

    @After
    public void resetProcessEngineConfig() {
        this.rule.getProcessEngineConfiguration().setPasswordPolicy(null).setEnablePasswordPolicy(false);
    }

    @Test
    public void testGoodPassword() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPas$w0rd");
        MatcherAssert.assertThat((Object)result.getViolatedRules().size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)result.getFulfilledRules().size(), (Matcher)Is.is((Object)5));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCheckValidPassword_WithoutPassingPolicy() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy("LongPas$w0rd");
        MatcherAssert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testPasswordWithoutLowerCase() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LONGPAS$W0RD");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_LOWERCASE"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyLowerCaseRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutUpperCase() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "longpas$w0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_UPPERCASE"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyUpperCaseRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutSpecialChar() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPassw0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_SPECIAL"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicySpecialCharacterRuleImpl.class));
    }

    @Test
    public void testPasswordWithoutDigit() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "LongPas$word");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_DIGIT"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyDigitRuleImpl.class));
    }

    @Test
    public void testShortPassword() {
        PasswordPolicyResult result = this.identityService.checkPasswordAgainstPolicy(this.policy, "Pas$w0rd");
        this.checkThatPasswordWasInvalid(result);
        PasswordPolicyRule rule = (PasswordPolicyRule)result.getViolatedRules().get(0);
        MatcherAssert.assertThat((Object)rule.getPlaceholder(), (Matcher)Is.is((Object)"PASSWORD_POLICY_LENGTH"));
        MatcherAssert.assertThat((Object)rule, (Matcher)IsInstanceOf.instanceOf(PasswordPolicyLengthRuleImpl.class));
    }

    @Test
    public void shouldThrowNullValueException_policyNull() {
        this.thrown.expectMessage("policy is null");
        this.thrown.expect(NullValueException.class);
        this.identityService.checkPasswordAgainstPolicy(null, "Pas$w0rd");
    }

    @Test
    public void shouldThrowNullValueException_passwordNull() {
        this.thrown.expectMessage("password is null");
        this.thrown.expect(NullValueException.class);
        this.identityService.checkPasswordAgainstPolicy(this.policy, null);
    }

    @Test
    public void shouldGetPasswordPolicy() {
        PasswordPolicy passwordPolicy = this.identityService.getPasswordPolicy();
        MatcherAssert.assertThat((Object)passwordPolicy, (Matcher)IsNull.notNullValue());
    }

    private void checkThatPasswordWasInvalid(PasswordPolicyResult result) {
        MatcherAssert.assertThat((Object)result.getViolatedRules().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)result.getFulfilledRules().size(), (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)Is.is((Object)false));
    }
}

