/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.test.WatchLogger;
import org.camunda.bpm.engine.test.util.LogEventComparator;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.LoggerFactory;

public class ProcessEngineLoggingRule
extends TestWatcher {
    public static final String LOGGER_NOT_FOUND_ERROR = "no logger found with name ";
    public static final String NOT_WATCHING_ERROR = "not watching any logger with name: ";
    private static final String APPENDER_NAME = "defaultAppender";
    Map<String, Logger> globallyWatched = new HashMap<String, Logger>();
    Level globalLevel = Level.DEBUG;
    Map<String, Logger> allWatched = new HashMap<String, Logger>();

    public ProcessEngineLoggingRule watch(String ... loggerName) {
        for (String logger : loggerName) {
            this.watch(logger, (Level)null);
        }
        return this;
    }

    public ProcessEngineLoggingRule watch(String loggerName, Level level) {
        Logger logger = this.getLogger(loggerName);
        logger.setLevel(level);
        this.globallyWatched.put(logger.getName(), logger);
        return this;
    }

    public ProcessEngineLoggingRule level(Level level) {
        this.globalLevel = level;
        return this;
    }

    private Logger getLogger(String loggerName) {
        Logger logger;
        try {
            logger = (Logger)LoggerFactory.getLogger((String)loggerName);
            if (logger.getLevel() == null || this.globalLevel.isGreaterOrEqual(logger.getLevel())) {
                logger.setLevel(this.globalLevel);
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(LOGGER_NOT_FOUND_ERROR + loggerName);
        }
        return logger;
    }

    public List<ILoggingEvent> getLog(String loggerName) {
        Logger logger = this.allWatched.get(loggerName);
        if (logger == null) {
            throw new RuntimeException(NOT_WATCHING_ERROR + loggerName);
        }
        return ((ListAppender)logger.getAppender((String)APPENDER_NAME)).list;
    }

    public List<ILoggingEvent> getLog() {
        ArrayList<ILoggingEvent> allLogs = new ArrayList<ILoggingEvent>();
        for (String loggerName : this.allWatched.keySet()) {
            allLogs.addAll(this.getLog(loggerName));
        }
        Collections.sort(allLogs, new LogEventComparator());
        return allLogs;
    }

    public List<ILoggingEvent> getFilteredLog(String subString) {
        List<ILoggingEvent> log = this.getLog();
        return this.filterLog(log, subString);
    }

    public List<ILoggingEvent> getFilteredLog(String loggerName, String subString) {
        List<ILoggingEvent> log = this.getLog(loggerName);
        return this.filterLog(log, subString);
    }

    protected void starting(Description description) {
        HashMap<String, Logger> tempWatched = new HashMap<String, Logger>();
        WatchLogger watchLoggerAnnotation = (WatchLogger)description.getAnnotation(WatchLogger.class);
        if (watchLoggerAnnotation != null) {
            Level level = Level.toLevel((String)watchLoggerAnnotation.level());
            if (level == null) {
                level = this.globalLevel;
            }
            for (String loggerName : watchLoggerAnnotation.loggerNames()) {
                Logger logger = this.getLogger(loggerName);
                logger.setLevel(level);
                tempWatched.put(loggerName, logger);
            }
        }
        this.watchLoggers(this.globallyWatched);
        this.watchLoggers(tempWatched);
    }

    protected void finished(Description description) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
    }

    private void watchLoggers(Map<String, Logger> loggers) {
        for (Map.Entry<String, Logger> loggerEntry : loggers.entrySet()) {
            ListAppender listAppender = new ListAppender();
            listAppender.setName(APPENDER_NAME);
            listAppender.start();
            Logger logger = loggerEntry.getValue();
            if (logger.getLevel() == null) {
                logger.setLevel(this.globalLevel);
            }
            logger.addAppender((Appender)listAppender);
            this.allWatched.put(loggerEntry.getKey(), logger);
        }
    }

    private List<ILoggingEvent> filterLog(List<ILoggingEvent> log, String subString) {
        ArrayList<ILoggingEvent> filteredLog = new ArrayList<ILoggingEvent>();
        for (ILoggingEvent logEntry : log) {
            if (!logEntry.getFormattedMessage().contains(subString)) continue;
            filteredLog.add(logEntry);
        }
        return filteredLog;
    }
}

