/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public abstract class AbstractUpdateProcessInstancesSuspendStateCmd<T>
implements Command<T> {
    protected UpdateProcessInstancesSuspensionStateBuilderImpl builder;
    protected CommandExecutor commandExecutor;
    protected boolean suspending;

    public AbstractUpdateProcessInstancesSuspendStateCmd(CommandExecutor commandExecutor, UpdateProcessInstancesSuspensionStateBuilderImpl builder, boolean suspending) {
        this.commandExecutor = commandExecutor;
        this.builder = builder;
        this.suspending = suspending;
    }

    protected Collection<String> collectProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> allProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.builder.getProcessInstanceIds();
        if (processInstanceIds != null) {
            allProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.builder.getProcessInstanceQuery()) != null) {
            allProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.builder.getHistoricProcessInstanceQuery()) != null) {
            allProcessInstanceIds.addAll(historicProcessInstanceQuery.listIds());
        }
        return allProcessInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        String operationType = this.suspending ? "SuspendJob" : "ActivateJob";
        commandContext.getOperationLogManager().logProcessInstanceOperation(operationType, null, null, null, propertyChanges);
    }
}

