/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.task;

import ch.qos.logback.classic.Level;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HandleTaskAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.bpmn.behavior"}).level(Level.INFO);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected static final String userId = "userId";
    protected String deploymentId;
    protected static final String BPMN_BEHAVIOR_LOGGER = "org.camunda.bpm.engine.bpmn.behavior";
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.TASK_WORK}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.TASK_WORK}), AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.UPDATE_TASK})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.TASK_WORK})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.TASK_WORK})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.UPDATE_TASK})).succeeds());
    }

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.authRule.createUserAndGroup(userId, "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    @Test
    public void testHandleTaskBpmnError() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deployWithResult().getId();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.handleBpmnError(taskId, "anErrorCode");
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult());
            Assertions.assertThat((int)this.loggingRule.getFilteredLog(BPMN_BEHAVIOR_LOGGER, "Execution is ended (none end event semantics)").size()).isEqualTo(1);
            Assertions.assertThat((int)this.loggingRule.getFilteredLog(BPMN_BEHAVIOR_LOGGER, "no catching boundary event was defined").size()).isEqualTo(1);
        }
    }

    @Test
    public void testHandleTaskEscalation() {
        BpmnModelInstance model = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("throw-escalation").boundaryEvent().escalation("anEscalationCode")).userTask("after-catch").moveToActivity("throw-escalation").userTask("after-throw").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("escalation.bpmn", model).deploy().getId();
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.handleEscalation(taskId, "anEscalationCode");
        if (this.authRule.assertScenario(this.scenario)) {
            List tasks = this.taskService.createTaskQuery().list();
            Assertions.assertThat((int)tasks.size()).isEqualTo(1);
            Assertions.assertThat((String)((Task)tasks.get(0)).getTaskDefinitionKey()).isEqualTo((Object)"after-catch");
        }
    }
}

