/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import camundajar.impl.com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cfg.BatchWindowConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupOnEngineBootstrapTest {
    private static final String ENGINE_NAME = "engineWithHistoryCleanupBatchWindow";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testConsecutiveEngineBootstrapHistoryCleanupJobReconfiguration() {
        ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/batchwindow.camunda.cfg.xml").buildProcessEngine().close();
        ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/no-batchwindow.camunda.cfg.xml").buildProcessEngine().close();
        ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/batchwindow.camunda.cfg.xml");
        processEngineConfiguration.setProcessEngineName(ENGINE_NAME);
        ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
        Assert.assertNotNull((Object)ProcessEngines.getProcessEngine((String)ENGINE_NAME));
        this.closeProcessEngine(processEngine);
    }

    @Test
    public void testDecreaseNumberOfHistoryCleanupJobs() {
        ProcessEngine engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-parallelism-default.camunda.cfg.xml").buildProcessEngine();
        ManagementService managementService = engine.getManagementService();
        Assert.assertEquals((long)4L, (long)managementService.createJobQuery().list().size());
        engine.close();
        engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-parallelism-less.camunda.cfg.xml").buildProcessEngine();
        managementService = engine.getManagementService();
        Assert.assertEquals((long)1L, (long)managementService.createJobQuery().list().size());
        Job job = (Job)managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.getHistoryCleanupJobHandlerConfiguration(job).getMinuteFrom());
        Assert.assertEquals((long)59L, (long)this.getHistoryCleanupJobHandlerConfiguration(job).getMinuteTo());
        this.closeProcessEngine(engine);
    }

    @Test
    public void testIncreaseNumberOfHistoryCleanupJobs() {
        ProcessEngine engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-parallelism-default.camunda.cfg.xml").buildProcessEngine();
        ManagementService managementService = engine.getManagementService();
        Assert.assertEquals((long)4L, (long)managementService.createJobQuery().count());
        engine.close();
        engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-parallelism-more.camunda.cfg.xml").buildProcessEngine();
        managementService = engine.getManagementService();
        List jobs = managementService.createJobQuery().list();
        Assert.assertEquals((long)8L, (long)jobs.size());
        for (Job job : jobs) {
            int minuteTo = this.getHistoryCleanupJobHandlerConfiguration(job).getMinuteTo();
            int minuteFrom = this.getHistoryCleanupJobHandlerConfiguration(job).getMinuteFrom();
            if (minuteFrom == 0) {
                Assert.assertEquals((long)6L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 7) {
                Assert.assertEquals((long)13L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 14) {
                Assert.assertEquals((long)20L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 21) {
                Assert.assertEquals((long)27L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 28) {
                Assert.assertEquals((long)34L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 35) {
                Assert.assertEquals((long)41L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 42) {
                Assert.assertEquals((long)48L, (long)minuteTo);
                continue;
            }
            if (minuteFrom == 49) {
                Assert.assertEquals((long)59L, (long)minuteTo);
                continue;
            }
            Assert.fail((String)("unexpected minute from " + minuteFrom));
        }
        this.closeProcessEngine(engine);
    }

    @Test
    public void testBatchWindowXmlConfigParsingException() throws ParseException {
        this.thrown.expect(Exception.class);
        this.thrown.expectMessage("startTime");
        ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-batch-window-map-wrong-values.camunda.cfg.xml").buildProcessEngine();
    }

    @Test
    public void testBatchWindowMapInXmlConfig() throws ParseException {
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-14T22:00:00"));
        ProcessEngine engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-batch-window-map.camunda.cfg.xml").buildProcessEngine();
        List historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-16T23:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        engine.close();
        engine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/history/history-cleanup-batch-window-default.camunda.cfg.xml").buildProcessEngine();
        historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-14T23:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        this.closeProcessEngine(engine);
    }

    @Test
    public void testHistoryCleanupJobScheduled() throws ParseException {
        ProcessEngineConfigurationImpl standaloneInMemProcessEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        standaloneInMemProcessEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        standaloneInMemProcessEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        standaloneInMemProcessEngineConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName() + "testHistoryCleanupJobScheduled");
        ProcessEngine engine = standaloneInMemProcessEngineConfiguration.buildProcessEngine();
        List historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
        for (Job historyCleanupJob : historyCleanupJobs) {
            Assert.assertEquals((Object)processEngineConfiguration.getBatchWindowManager().getCurrentOrNextBatchWindow(ClockUtil.getCurrentTime(), processEngineConfiguration).getStart(), (Object)historyCleanupJob.getDuedate());
        }
        this.closeProcessEngine(engine);
    }

    @Test
    public void testBatchWindowOneDayOfWeek() throws ParseException {
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-14T22:00:00"));
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        configuration.getHistoryCleanupBatchWindows().put(2, new BatchWindowConfiguration("18:00", "20:00"));
        configuration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName() + "testBatchWindowOneDayOfWeek");
        ProcessEngine engine = configuration.buildProcessEngine();
        List historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-21T18:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-21T20:00:01"));
        engine.getManagementService().executeJob(((Job)historyCleanupJobs.get(0)).getId());
        historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-28T18:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        this.closeProcessEngine(engine);
    }

    @Test
    public void testBatchWindow24Hours() throws ParseException {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        configuration.getHistoryCleanupBatchWindows().put(2, new BatchWindowConfiguration("06:00", "06:00"));
        configuration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName() + "testBatchWindow24Hours");
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-14T05:00:00"));
        ProcessEngine engine = configuration.buildProcessEngine();
        List historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-14T06:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-14T15:00:00"));
        engine.getManagementService().executeJob(((Job)historyCleanupJobs.get(0)).getId());
        historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertTrue((boolean)sdf.parse("2018-05-15T06:00:00").after(((Job)historyCleanupJobs.get(0)).getDuedate()));
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-15T05:59:00"));
        engine.getManagementService().executeJob(((Job)historyCleanupJobs.get(0)).getId());
        historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertTrue((boolean)sdf.parse("2018-05-15T06:00:00").after(((Job)historyCleanupJobs.get(0)).getDuedate()));
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-15T06:01:00"));
        engine.getManagementService().executeJob(((Job)historyCleanupJobs.get(0)).getId());
        historyCleanupJobs = engine.getHistoryService().findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Assert.assertEquals((Object)sdf.parse("2018-05-21T06:00:00"), (Object)((Job)historyCleanupJobs.get(0)).getDuedate());
        Assert.assertEquals((Object)false, (Object)((Job)historyCleanupJobs.get(0)).isSuspended());
        this.closeProcessEngine(engine);
    }

    protected HistoryCleanupJobHandlerConfiguration getHistoryCleanupJobHandlerConfiguration(Job job) {
        return HistoryCleanupJobHandlerConfiguration.fromJson((JsonObject)JsonUtil.asObject((String)((JobEntity)job).getJobHandlerConfigurationRaw()));
    }

    protected void closeProcessEngine(ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        final HistoryService historyService = processEngine.getHistoryService();
        configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = historyService.findHistoryCleanupJobs();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                List list = historyService.createHistoricJobLogQuery().list();
                for (HistoricJobLog jobLog : list) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobLog.getJobId());
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
        processEngine.close();
    }
}

