/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeNonHierarchicalTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    protected final Date REMOVAL_TIME;
    protected final Date CREATE_TIME;
    protected RuntimeService runtimeService;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;

    public BatchSetRemovalTimeNonHierarchicalTest() {
        this.REMOVAL_TIME = this.testRule.REMOVAL_TIME;
        this.CREATE_TIME = new Date(1363608000000L);
    }

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecision_DecisionInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInputInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecision_DecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionOutputInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecision_DecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("season").singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("season").singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ProcessInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ActivityInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_TaskInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_VariableInstance() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Detail() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog() {
        this.testRule.process().externalTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isNull();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog_WithPreservedCreateTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().externalTask().deploy().start();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_JobLog() {
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        HistoricJobLog job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Incident() {
        this.testRule.process().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Incident_WithPreservedCreateTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getCreateTime()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getCreateTime()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_OperationLog() {
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_OperationLog_WithPreservedTimestamp() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog() {
        this.testRule.process().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog_WithPreservedTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getTime()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getTime()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldNotSetUnaffectedRemovalTime_IdentityLinkLog() {
        BatchSetRemovalTimeRule.TestProcessBuilder testProcessBuilder = this.testRule.process().userTask().deploy();
        String instance1 = testProcessBuilder.start();
        String instance2 = testProcessBuilder.start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query.processInstanceId(instance1)).executeAsync());
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2).singleResult();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().taskId(task2.getId()).singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_CommentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        this.taskService.createComment(taskId, null, "aComment");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_CommentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        this.taskService.createComment(null, processInstanceId, "aComment");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        Attachment attachment = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Attachment attachment = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        attachment = (Attachment)this.taskService.getProcessInstanceAttachments(processInstanceId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, processInstanceId, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        String byteArrayId = attachment.getContentId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_Variable() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.fileValue((String)"file.xml").file("<root />".getBytes())));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        String byteArrayId = ((HistoricVariableInstanceEntity)historicVariableInstance).getByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_JobLog() {
        this.testRule.process().async().scriptTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricJobLogEventEntity)historicJobLog).getExceptionByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_ExternalTaskLog() {
        this.testRule.process().externalTask().deploy().start();
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricExternalTaskLogEntity)externalTaskLog).getErrorDetailsByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionInputInstance() {
        this.testRule.process().ruleTask("testDecision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecisions_ByteArray_DecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("testDecision").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionOutputInstance() {
        this.testRule.process().ruleTask("testDecision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecisions_ByteArray_DecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("testDecision").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeToBatch() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTimeToBatch_JobLog() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batch.getId()).singleResult();
        Assertions.assertThat((Date)historicJobLog.getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batch.getId()).singleResult();
        Assertions.assertThat((Date)historicJobLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTimeToBatch_JobLogByteArray() {
        String processInstance = this.testRule.process().failingCustomListener().deploy().start();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstance), "aDeleteReason");
        try {
            this.testRule.syncExec(batch);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((Throwable)e).hasMessage("I'm supposed to fail!");
        }
        HistoricJobLogEventEntity historicJobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batch.getId()).failureLog().singleResult();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(historicJobLog.getExceptionByteArrayId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(historicJobLog.getExceptionByteArrayId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batch.getId(), true);
        this.runtimeService.deleteProcessInstance(processInstance, "", true);
    }

    @Test
    public void shouldSetRemovalTimeToBatch_Incident() {
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList("aProcessInstanceId"), "aDeleteReason");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batch.getId(), true);
    }
}

