/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class SuspendJobDefinitionTest
extends PluggableProcessEngineTestCase {
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
                return null;
            }
        });
    }

    public void testSuspensionById_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByIdAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null, false);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByIdAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null, false, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, false, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        SuspendJobDefinitionTest.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByIdAndSuspendJobsFlag_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByIdAndSuspendJobsFlag_shouldSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldExecuteImmediatelyAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldExecuteImmediatelyAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldExecuteDelayedAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldExecuteDelayedAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    public void testSuspensionByProcessDefinitionId_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        SuspendJobDefinitionTest.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    public void testSuspensionByProcessDefinitionKey_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true, null);
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true, new Date());
            SuspendJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        SuspendJobDefinitionTest.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJobDefinition.getId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        SuspendJobDefinitionTest.assertFalse((boolean)jobDefinition.isSuspended());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).suspend();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        SuspendJobDefinitionTest.assertFalse((boolean)jobDefinition.isSuspended());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        SuspendJobDefinitionTest.assertFalse((boolean)jobDefinition.isSuspended());
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey("suspensionProcess").suspend();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionJobDefinitionIncludeJobsdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        SuspendJobDefinitionTest.assertFalse((boolean)jobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).includeJobs(true).suspend();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testDelayedSuspensionUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).executionDate(this.oneWeekLater()).suspend();
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.active().count());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)query.suspended().count());
        Job delayedSuspensionJob = (Job)this.managementService.createJobQuery().timers().active().singleResult();
        SuspendJobDefinitionTest.assertNotNull((Object)delayedSuspensionJob);
        this.managementService.executeJob(delayedSuspensionJob.getId());
        SuspendJobDefinitionTest.assertEquals((long)0L, (long)query.active().count());
        SuspendJobDefinitionTest.assertEquals((long)1L, (long)query.suspended().count());
    }

    protected Date oneWeekLater() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        return new Date(oneWeekFromStartTime);
    }
}

