/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyVariableInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        this.startProcessInstanceForTenant(TENANT_ONE);
        this.startProcessInstanceForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.runtimeService.createVariableInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createVariableInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyVariableInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List variableInstances = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)variableInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((VariableInstance)variableInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((VariableInstance)variableInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List variableInstances = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)variableInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((VariableInstance)variableInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((VariableInstance)variableInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected void startProcessInstanceForTenant(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)"test");
        this.runtimeService.startProcessInstanceById(processDefinitionId, (Map)variables);
    }
}

