/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyTaskVariableCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String VARIABLE_1 = "testVariable1";
    protected static final String VARIABLE_2 = "testVariable2";
    protected static final String VARIABLE_VALUE_1 = "test1";
    protected static final String VARIABLE_VALUE_2 = "test2";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("task").endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected String taskId;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)Variables.createVariables().putValue(VARIABLE_1, (Object)VARIABLE_VALUE_1).putValue(VARIABLE_2, (Object)VARIABLE_VALUE_2)).getId();
        this.taskId = ((Task)this.engineRule.getTaskService().createTaskQuery().singleResult()).getId();
    }

    @Test
    public void getTaskVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getTaskService().getVariable(this.taskId, VARIABLE_1));
    }

    @Test
    public void getTaskVariableWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot read the task '" + this.taskId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getTaskService().getVariable(this.taskId, VARIABLE_1);
    }

    @Test
    public void getTaskVariableWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getTaskService().getVariable(this.taskId, VARIABLE_1));
    }

    @Test
    public void getTaskVariableTypedWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getTaskService().getVariableTyped(this.taskId, VARIABLE_1).getValue());
    }

    @Test
    public void getTaskVariableTypedWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot read the task '" + this.taskId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getTaskService().getVariableTyped(this.taskId, VARIABLE_1).getValue();
    }

    @Test
    public void getTaskVariableTypedWithDisableTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getTaskService().getVariableTyped(this.taskId, VARIABLE_1).getValue());
    }

    @Test
    public void getTaskVariablesWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((long)2L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }

    @Test
    public void getTaskVariablesWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot read the task '" + this.taskId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getTaskService().getVariables(this.taskId).size();
    }

    @Test
    public void getTaskVariablesWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((long)2L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }

    @Test
    public void setTaskVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getTaskService().setVariable(this.taskId, "newVariable", (Object)"newValue");
        Assert.assertEquals((long)3L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }

    @Test
    public void setTaskVariableWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the task '" + this.taskId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getTaskService().setVariable(this.taskId, "newVariable", (Object)"newValue");
    }

    @Test
    public void setTaskVariableWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getTaskService().setVariable(this.taskId, "newVariable", (Object)"newValue");
        Assert.assertEquals((long)3L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }

    @Test
    public void removeTaskVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getTaskService().removeVariable(this.taskId, VARIABLE_1);
        Assert.assertEquals((long)1L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }

    @Test
    public void removeTaskVariablesWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the task '" + this.taskId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getTaskService().removeVariable(this.taskId, VARIABLE_1);
    }

    @Test
    public void removeTaskVariablesWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getTaskService().removeVariable(this.taskId, VARIABLE_1);
        Assert.assertEquals((long)1L, (long)this.engineRule.getTaskService().getVariables(this.taskId).size());
    }
}

