/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.queries;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.queries.BoundedNumberOfMaxResultsDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BoundedNumberOfMaxResultsTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected BpmnModelInstance simpleProcess = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
    protected BpmnModelInstance externalTaskProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaExternalTask("aTopicName")).endEvent().done();

    @Before
    public void assignServices() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void enableMaxResultsLimit() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(10);
    }

    @Before
    public void authenticate() {
        this.engineRule.getIdentityService().setAuthenticatedUserId("foo");
    }

    @After
    public void clearAuthentication() {
        this.engineRule.getIdentityService().clearAuthentication();
    }

    @After
    public void resetQueryMaxResultsLimit() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(Integer.MAX_VALUE);
    }

    @Test
    public void shouldReturnUnboundedResults_UnboundMaxResults() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(Integer.MAX_VALUE);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        List processInstances = processInstanceQuery.list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(0);
    }

    @Test
    public void shouldReturnUnboundedResults_NotAuthenticated() {
        this.identityService.clearAuthentication();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        List processInstances = processInstanceQuery.list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(0);
    }

    @Test
    public void shouldReturnUnboundedResults_InsideCmd() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List tasks = commandContext.getProcessEngineConfiguration().getTaskService().createTaskQuery().list();
                Assertions.assertThat((int)tasks.size()).isEqualTo(1);
                return null;
            }
        });
        this.taskService.deleteTask(task.getId(), true);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldReturnUnboundedResults_InsideCmd2() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").endEvent().done();
        String processDefinitionId = ((ProcessDefinition)this.testHelper.deploy(process).getDeployedProcessDefinitions().get(0)).getId();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getProcessInstanceId();
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinitionId).processInstanceIds(new String[]{processInstanceId}).startAfterActivity("startEvent")).execute();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"The query inside the command should not throw an exception!");
        }
    }

    @Test
    public void shouldThrowException_UnboundedResultsForList() {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("An unbound number of results is forbidden!");
        processInstanceQuery.list();
    }

    @Test
    public void shouldThrowException_MaxResultsLimitExceeded() {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Max results limit of 10 exceeded!");
        processInstanceQuery.listPage(0, 11);
    }

    @Test
    public void shouldNotThrowException_unboundedResultList() {
        ProcessInstanceQueryImpl processInstanceQuery = (ProcessInstanceQueryImpl)this.runtimeService.createProcessInstanceQuery();
        this.testHelper.deploy(this.simpleProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        List processInstances = processInstanceQuery.unboundedResultList();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(1);
    }

    @Test
    public void shouldThrowExceptionWhenFilterQueryList_MaxResultsLimitExceeded() {
        Filter foo = this.engineRule.getFilterService().newTaskFilter("foo");
        foo.setQuery((Query)this.taskService.createTaskQuery());
        this.engineRule.getFilterService().saveFilter(foo);
        String filterId = ((Filter)this.engineRule.getFilterService().createFilterQuery().singleResult()).getId();
        try {
            this.engineRule.getFilterService().list(filterId);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("An unbound number of results is forbidden!");
        }
        this.engineRule.getFilterService().deleteFilter(filterId);
    }

    @Test
    public void shouldThrowExceptionWhenFilterQueryListPage_MaxResultsLimitExceeded() {
        Filter foo = this.engineRule.getFilterService().newTaskFilter("foo");
        foo.setQuery((Query)this.taskService.createTaskQuery());
        this.engineRule.getFilterService().saveFilter(foo);
        String filterId = ((Filter)this.engineRule.getFilterService().createFilterQuery().singleResult()).getId();
        try {
            this.engineRule.getFilterService().listPage(filterId, 0, 11);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 10 exceeded!");
        }
        this.engineRule.getFilterService().deleteFilter(filterId);
    }

    @Test
    public void shouldThrowExceptionWhenExtendedFilterQueryList_MaxResultsLimitExceeded() {
        Filter foo = this.engineRule.getFilterService().newTaskFilter("foo");
        foo.setQuery((Query)this.taskService.createTaskQuery());
        this.engineRule.getFilterService().saveFilter(foo);
        String filterId = ((Filter)this.engineRule.getFilterService().createFilterQuery().singleResult()).getId();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskCandidateGroup("aCandidateGroup");
        try {
            this.engineRule.getFilterService().list(filterId, (Query)extendingQuery);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("An unbound number of results is forbidden!");
        }
        this.engineRule.getFilterService().deleteFilter(filterId);
    }

    @Test
    public void shouldThrowExceptionWhenSyncSetRetriesForExternalTasks_MaxResultsLimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.engineRule.getExternalTaskService().updateRetries().externalTaskQuery(this.engineRule.getExternalTaskService().createExternalTaskQuery()).set(5);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @Test
    public void shouldSyncUpdateExternalTaskRetries() {
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.engineRule.getExternalTaskService().updateRetries().externalTaskQuery(this.engineRule.getExternalTaskService().createExternalTaskQuery()).set(5);
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldThrowExceptionWhenSyncSetRetriesForExtTasksByHistProcInstQuery_LimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery();
        try {
            this.engineRule.getExternalTaskService().updateRetries().historicProcessInstanceQuery(historicProcessInstanceQuery).set(5);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSyncUpdateExternalTaskRetriesProcInstQueryByHistProcInstQuery() {
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery();
        try {
            this.engineRule.getExternalTaskService().updateRetries().historicProcessInstanceQuery(historicProcessInstanceQuery).set(5);
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @Test
    public void shouldSyncUpdateExternalTaskRetriesByProcInstQuery() {
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.engineRule.getExternalTaskService().updateRetries().processInstanceQuery(this.engineRule.getRuntimeService().createProcessInstanceQuery()).set(5);
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldThrowExceptionWhenSyncSetRetriesForExtTasksByProcInstQuery_LimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.engineRule.getExternalTaskService().updateRetries().processInstanceQuery(this.engineRule.getRuntimeService().createProcessInstanceQuery()).set(5);
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSyncUpdateExternalTaskRetriesByHistProcInstQuery() {
        this.testHelper.deploy(this.externalTaskProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery();
        try {
            this.engineRule.getExternalTaskService().updateRetries().historicProcessInstanceQuery(historicProcessInstanceQuery).set(5);
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @Test
    public void shouldThrowExceptionWhenSyncInstanceMigration_MaxResultsLimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        String source = ((ProcessDefinition)this.testHelper.deploy(this.simpleProcess).getDeployedProcessDefinitions().get(0)).getId();
        String target = ((ProcessDefinition)this.testHelper.deploy(this.simpleProcess).getDeployedProcessDefinitions().get(0)).getId();
        MigrationPlan plan = this.runtimeService.createMigrationPlan(source, target).mapEqualActivities().build();
        this.runtimeService.startProcessInstanceById(source);
        this.runtimeService.startProcessInstanceById(source);
        this.runtimeService.startProcessInstanceById(source);
        try {
            this.runtimeService.newMigration(plan).processInstanceQuery(this.runtimeService.createProcessInstanceQuery()).execute();
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @Test
    public void shouldSyncInstanceMigration() {
        String source = ((ProcessDefinition)this.testHelper.deploy(this.simpleProcess).getDeployedProcessDefinitions().get(0)).getId();
        String target = ((ProcessDefinition)this.testHelper.deploy(this.simpleProcess).getDeployedProcessDefinitions().get(0)).getId();
        MigrationPlan plan = this.runtimeService.createMigrationPlan(source, target).mapEqualActivities().build();
        this.runtimeService.startProcessInstanceById(source);
        try {
            this.runtimeService.newMigration(plan).processInstanceQuery(this.runtimeService.createProcessInstanceQuery()).execute();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No Exception expected!");
        }
    }

    @Test
    public void shouldThrowExceptionWhenInstanceModification_MaxResultsLimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        String processDefinitionId = ((ProcessDefinition)this.testHelper.deploy(process).getDeployedProcessDefinitions().get(0)).getId();
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((ModificationBuilder)this.runtimeService.createModification(processDefinitionId).startAfterActivity("userTask")).processInstanceQuery(this.runtimeService.createProcessInstanceQuery()).execute();
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @Test
    public void shouldSyncProcessInstanceModification() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        String processDefinitionId = ((ProcessDefinition)this.testHelper.deploy(process).getDeployedProcessDefinitions().get(0)).getId();
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((ModificationBuilder)this.runtimeService.createModification(processDefinitionId).startAfterActivity("userTask")).processInstanceQuery(this.runtimeService.createProcessInstanceQuery()).execute();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"Exception expected!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldThrowExceptionWhenRestartProcessInstance_MaxResultsLimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").endEvent().done();
        String processDefinitionId = ((ProcessDefinition)this.testHelper.deploy(process).getDeployedProcessDefinitions().get(0)).getId();
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinitionId).historicProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery()).startAfterActivity("startEvent")).execute();
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSyncRestartProcessInstance() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").endEvent().done();
        String processDefinitionId = ((ProcessDefinition)this.testHelper.deploy(process).getDeployedProcessDefinitions().get(0)).getId();
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinitionId).historicProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery()).startAfterActivity("startEvent")).execute();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"Exception expected!");
        }
    }

    @Test
    public void shouldThrowExceptionWhenUpdateProcessInstanceSuspensionState_LimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        this.testHelper.deploy(this.simpleProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery()).suspend();
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @Test
    public void shouldSyncUpdateProcessInstanceSuspensionState() {
        this.testHelper.deploy(this.simpleProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceQuery(this.runtimeService.createProcessInstanceQuery()).suspend();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldThrowExceptionWhenUpdateProcInstSuspStateByHistProcInstQuery_LimitExceeded() {
        this.engineRule.getProcessEngineConfiguration().setQueryMaxResultsLimit(2);
        this.testHelper.deploy(this.simpleProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery()).suspend();
            Assertions.fail((String)"Exception expected!");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max results limit of 2 exceeded!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSyncUpdateProcessInstanceSuspensionStateByHistProcInstQuery() {
        this.testHelper.deploy(this.simpleProcess);
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.updateProcessInstanceSuspensionState().byHistoricProcessInstanceQuery(this.historyService.createHistoricProcessInstanceQuery()).suspend();
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"No exception expected!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldReturnResultWhenMaxResultsLimitNotExceeded() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").endEvent().done();
        this.testHelper.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        List historicProcessInstances = historicProcessInstanceQuery.listPage(0, 10);
        Assertions.assertThat((int)historicProcessInstances.size()).isEqualTo(1);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldReturnResultWhenMaxResultsLimitNotExceeded2() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").endEvent().done();
        this.testHelper.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        List historicProcessInstances = historicProcessInstanceQuery.listPage(0, 9);
        Assertions.assertThat((int)historicProcessInstances.size()).isEqualTo(1);
    }

    @Test
    public void shouldReturnResultInsideJavaDelegate() {
        BpmnModelInstance process = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask().camundaClass(BoundedNumberOfMaxResultsDelegate.class)).endEvent().done();
        this.testHelper.deploy(process);
        try {
            this.runtimeService.startProcessInstanceByKey("process");
        }
        catch (BadUserRequestException e) {
            Assertions.fail((String)"Should not throw exception inside command!");
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldReturnSingleResult_BoundedMaxResults() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
    }
}

