/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.resources;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.repository.ResourceTypes;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RepositoryByteArrayTest {
    protected static final String USER_ID = "johndoe";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;

    @Before
    public void initServices() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        this.identityService.deleteUser(USER_ID);
    }

    @Test
    public void testResourceBinary() {
        Date fixedDate = new Date();
        ClockUtil.setCurrentTime((Date)fixedDate);
        String bpmnDeploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").getId();
        String dmnDeploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/repository/one.dmn").getId();
        String cmmnDeplymentId = this.testRule.deploy("org/camunda/bpm/engine/test/repository/one.cmmn").getId();
        this.checkResource(fixedDate, bpmnDeploymentId);
        this.checkResource(fixedDate, dmnDeploymentId);
        this.checkResource(fixedDate, cmmnDeplymentId);
    }

    @Test
    public void testFormsBinaries() {
        Date fixedDate = new Date();
        ClockUtil.setCurrentTime((Date)fixedDate);
        String deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form", "org/camunda/bpm/engine/test/api/authorization/renderedFormProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        List deploymentResources = this.repositoryService.getDeploymentResources(deploymentId);
        Assert.assertEquals((long)5L, (long)deploymentResources.size());
        for (Resource resource : deploymentResources) {
            ResourceEntity entity = (ResourceEntity)resource;
            this.checkEntity(fixedDate, entity);
        }
    }

    @Test
    public void testUserPictureBinary() {
        Date fixedDate = new Date();
        ClockUtil.setCurrentTime((Date)fixedDate);
        User user = this.identityService.newUser(USER_ID);
        this.identityService.saveUser(user);
        String userId = user.getId();
        Picture picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        String userInfo = this.identityService.getUserInfo(USER_ID, "picture");
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(userInfo));
        Assert.assertNotNull((Object)byteArrayEntity);
        Assert.assertEquals((Object)fixedDate.toString(), (Object)byteArrayEntity.getCreateTime().toString());
        Assert.assertEquals((Object)ResourceTypes.REPOSITORY.getValue(), (Object)byteArrayEntity.getType());
    }

    protected void checkResource(Date expectedDate, String deploymentId) {
        List deploymentResources = this.repositoryService.getDeploymentResources(deploymentId);
        Assert.assertEquals((long)1L, (long)deploymentResources.size());
        ResourceEntity resource = (ResourceEntity)deploymentResources.get(0);
        this.checkEntity(expectedDate, resource);
    }

    protected void checkEntity(Date expectedDate, ResourceEntity entity) {
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)expectedDate.toString(), (Object)entity.getCreateTime().toString());
        Assert.assertEquals((Object)ResourceTypes.REPOSITORY.getValue(), (Object)entity.getType());
    }
}

