/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MessageStartEventTest
extends PluggableProcessEngineTestCase {
    public void testDeploymentCreatesSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)eventSubscriptions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameMessageNameFails() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/otherProcessWithNewInvoiceMessage.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("there already is a message event subscription for the message with name"));
        }
        finally {
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment deployment : deployments) {
                this.repositoryService.deleteDeployment(deployment.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
        }
    }

    public void testSameMessageNameInSameProcessFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/testSameMessageNameInSameProcessFails.bpmn20.xml").deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have more than one message event subscription with name 'newInvoiceMessage' for scope"));
        }
    }

    public void testUpdateProcessVersionCancelsSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)eventSubscriptions.size());
        MessageStartEventTest.assertEquals((int)1, (int)processDefinitions.size());
        String newDeploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List newProcessDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        MessageStartEventTest.assertEquals((int)1, (int)newEventSubscriptions.size());
        MessageStartEventTest.assertEquals((int)2, (int)newProcessDefinitions.size());
        for (ProcessDefinition processDefinition : newProcessDefinitions) {
            EventSubscriptionEntity subscriptionEntity;
            if (processDefinition.getVersion() == 1) {
                for (EventSubscription subscription : newEventSubscriptions) {
                    subscriptionEntity = (EventSubscriptionEntity)subscription;
                    MessageStartEventTest.assertFalse((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
                }
                continue;
            }
            for (EventSubscription subscription : newEventSubscriptions) {
                subscriptionEntity = (EventSubscriptionEntity)subscription;
                MessageStartEventTest.assertTrue((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
            }
        }
        MessageStartEventTest.assertFalse((boolean)eventSubscriptions.equals(newEventSubscriptions));
        this.repositoryService.deleteDeployment(deploymentId);
        this.repositoryService.deleteDeployment(newDeploymentId);
    }

    @Deployment
    public void testSingleMessageStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("singleMessageStartEvent");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMessageStartEventAndNoneStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterNoneStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testMultipleMessageStartEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage2");
        MessageStartEventTest.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart2").singleResult();
        MessageStartEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((String)("different exception expected, not " + e.getMessage()), (boolean)e.getMessage().contains("has no default start activity"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    public void testDeployStartAndIntermediateEventWithSameMessageInSameProcess() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByMessage("message");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertThat((Object)pi.isEnded(), (Matcher)CoreMatchers.is((Object)false));
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageInSameProcess.bpmn").name("deployment2").deploy().getId();
            Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses.bpmn"})
    public void testDeployStartAndIntermediateEventWithSameMessageDifferentProcessesFirstStartEvent() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByMessage("message");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertThat((Object)pi.isEnded(), (Matcher)CoreMatchers.is((Object)false));
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses2.bpmn").name("deployment2").deploy().getId();
            Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses2.bpmn"})
    public void testDeployStartAndIntermediateEventWithSameMessageDifferentProcessesFirstIntermediateEvent() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByKey("Process_2");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertThat((Object)pi.isEnded(), (Matcher)CoreMatchers.is((Object)false));
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses.bpmn").name("deployment2").deploy().getId();
            Assert.assertThat((Object)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    public void testUsingExpressionWithDollarTagInMessageStartEventNameThrowsException() {
        String processDefinition = "org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testUsingExpressionWithDollarTagInMessageStartEventNameThrowsException.bpmn20.xml";
        try {
            this.repositoryService.createDeployment().addClasspathResource(processDefinition).deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Invalid message name"));
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("expressions in the message start event name are not allowed!"));
        }
    }

    public void testUsingExpressionWithHashTagInMessageStartEventNameThrowsException() {
        String processDefinition = "org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testUsingExpressionWithHashTagInMessageStartEventNameThrowsException.bpmn20.xml";
        try {
            this.repositoryService.createDeployment().addClasspathResource(processDefinition).deploy();
            MessageStartEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("Invalid message name"));
            MessageStartEventTest.assertTrue((boolean)e.getMessage().contains("expressions in the message start event name are not allowed!"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testMessageStartEventUsingCorrelationEngine.bpmn"})
    public void testMessageStartEventUsingCorrelationEngineAndLocalVariable() {
        ProcessInstance processInstance = this.runtimeService.createMessageCorrelation("newCorrelationStartMessage").setVariableLocal("var", (Object)"value").correlateWithResult().getProcessInstance();
        String processInstanceValue = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "var");
        Assert.assertThat((Object)processInstanceValue, (Matcher)CoreMatchers.equalTo((Object)"value"));
    }
}

