/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class TimeExpressionTest
extends PluggableProcessEngineTestCase {
    private Date testExpression(String timeExpression) {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("dueDate", timeExpression);
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        TimeExpressionTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        List jobs = this.managementService.createJobQuery().executable().list();
        TimeExpressionTest.assertEquals((int)1, (int)jobs.size());
        return ((Job)jobs.get(0)).getDuedate();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionComplete() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dt));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dt), (String)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(dueDate));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionWithoutSeconds() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dt));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dt), (String)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(dueDate));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionWithoutMinutes() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd'T'HH").format(new Date()));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy-MM-dd'T'HH").format(dt), (String)new SimpleDateFormat("yyyy-MM-dd'T'HH").format(dueDate));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionWithoutTime() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy-MM-dd").format(dt), (String)new SimpleDateFormat("yyyy-MM-dd").format(dueDate));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionWithoutDay() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy-MM").format(new Date()));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy-MM").format(dt), (String)new SimpleDateFormat("yyyy-MM").format(dueDate));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpression.bpmn20.xml"})
    public void testTimeExpressionWithoutMonth() throws Exception {
        Date dt = new Date();
        Date dueDate = this.testExpression(new SimpleDateFormat("yyyy").format(new Date()));
        TimeExpressionTest.assertEquals((String)new SimpleDateFormat("yyyy").format(dt), (String)new SimpleDateFormat("yyyy").format(dueDate));
    }
}

