/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.TerminateEventDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class HistoricProcessInstanceStateTest {
    public static final String TERMINATION = "termination";
    public static final String PROCESS_ID = "process1";
    public static final String REASON = "very important reason";
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTerminatedInternalWithGateway() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway().endEvent().moveToLastGateway().endEvent(TERMINATION).done();
        HistoricProcessInstanceStateTest.initEndEvent(instance, TERMINATION);
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"COMPLETED"));
    }

    @Test
    public void testCompletedOnEndEvent() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"COMPLETED"));
    }

    @Test
    public void testCompletionWithSuspension() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessInstanceId(processInstance.getId()).suspend();
        entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"SUSPENDED"));
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessInstanceId(processInstance.getId()).activate();
        entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        this.processEngineRule.getTaskService().complete(((Task)this.processEngineRule.getTaskService().createTaskQuery().active().singleResult()).getId());
        entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"COMPLETED"));
    }

    @Test
    public void testSuspensionByProcessDefinition() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance1 = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance2 = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        HistoricProcessInstance hpi1 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        HistoricProcessInstance hpi2 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertThat((Object)hpi1.getState(), (Matcher)Is.is((Object)"SUSPENDED"));
        Assert.assertThat((Object)hpi2.getState(), (Matcher)Is.is((Object)"SUSPENDED"));
        Assert.assertEquals((long)2L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().suspended().count());
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinition.getKey()).activate();
        hpi1 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstance1.getId()).singleResult();
        hpi2 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertThat((Object)hpi1.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        Assert.assertThat((Object)hpi2.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        Assert.assertEquals((long)2L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().active().count());
    }

    @Test
    public void testCancellationState() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        this.processEngineRule.getRuntimeService().deleteProcessInstance(processInstance.getId(), REASON, false, true);
        entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"EXTERNALLY_TERMINATED"));
        Assert.assertEquals((long)1L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().externallyTerminated().count());
    }

    @Test
    public void testSateOfScriptTaskProcessWithTransactionCommitAndException() {
        BpmnModelInstance instance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().camundaAsyncAfter()).scriptTask().scriptText("throw new RuntimeException()")).scriptFormat("groovy")).endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        try {
            ProcessInstance pi = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
            this.processEngineRule.getManagementService().executeJob(((Job)this.processEngineRule.getManagementService().createJobQuery().executable().singleResult()).getId());
            TestCase.fail((String)"exception expected");
        }
        catch (Exception pi) {
            // empty catch block
        }
        Assert.assertThat((Object)this.processEngineRule.getRuntimeService().createProcessInstanceQuery().active().list().size(), (Matcher)Is.is((Object)1));
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        Assert.assertEquals((long)1L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().active().count());
    }

    @Test
    public void testErrorEndEvent() {
        BpmnModelInstance process1 = ((EndEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().error("1")).done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(process1);
        this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        HistoricProcessInstance entity = this.getHistoricProcessInstanceWithAssertion(processDefinition);
        Assert.assertThat((Object)entity.getState(), (Matcher)Is.is((Object)"COMPLETED"));
        Assert.assertEquals((long)1L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().completed().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricProcessInstanceStateTest.testWithCallActivity.bpmn"})
    public void testWithCallActivity() {
        this.processEngineRule.getRuntimeService().startProcessInstanceByKey("Main_Process");
        Assert.assertThat((Object)this.processEngineRule.getRuntimeService().createProcessInstanceQuery().active().list().size(), (Matcher)Is.is((Object)0));
        HistoricProcessInstance entity1 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionKey("Main_Process").singleResult();
        HistoricProcessInstance entity2 = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionKey("Sub_Process").singleResult();
        Assert.assertThat((Object)entity1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)entity2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)entity1.getState(), (Matcher)Is.is((Object)"COMPLETED"));
        Assert.assertEquals((long)1L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().completed().count());
        Assert.assertThat((Object)entity2.getState(), (Matcher)Is.is((Object)"INTERNALLY_TERMINATED"));
        Assert.assertEquals((long)1L, (long)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().internallyTerminated().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/CAM-9934.bpmn"})
    public void shouldSetCorrectInstanceStateOnInterruption() {
        this.processEngineRule.getRuntimeService().startProcessInstanceByKey("Process_1");
        this.processEngineRule.getRuntimeService().correlateMessage("SubProcessTrigger");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)historicProcessInstance.getState(), (Matcher)Is.is((Object)"ACTIVE"));
        Assert.assertThat((Object)historicProcessInstance.getEndTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/CAM-9934.bpmn"})
    public void shouldSetRemovalTimeOnHistoricActivityInstances() {
        this.processEngineRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start");
        this.processEngineRule.getRuntimeService().startProcessInstanceByKey("Process_1");
        this.processEngineRule.getRuntimeService().correlateMessage("SubProcessTrigger");
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)this.processEngineRule.getHistoryService().createHistoricTaskInstanceQuery().taskDefinitionKey("Task_1eg238f").singleResult();
        Assert.assertThat((Object)taskInstance.getRemovalTime(), (Matcher)IsNull.notNullValue());
        this.processEngineRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end");
    }

    private HistoricProcessInstance getHistoricProcessInstanceWithAssertion(ProcessDefinition processDefinition) {
        List entities = this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list();
        Assert.assertThat((Object)entities, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)entities.size(), (Matcher)Is.is((Object)1));
        return (HistoricProcessInstance)entities.get(0);
    }

    protected static void initEndEvent(BpmnModelInstance modelInstance, String endEventId) {
        EndEvent endEvent = (EndEvent)modelInstance.getModelElementById(endEventId);
        TerminateEventDefinition terminateDefinition = (TerminateEventDefinition)modelInstance.newInstance(TerminateEventDefinition.class);
        endEvent.addChildElement((ModelElementInstance)terminateDefinition);
    }
}

