/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.logging.TestApplicationReusingExistingEngine;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ProcessDataLoggingContextTest {
    private static final String PROCESS = "process";
    private static final String B_KEY = "businessKey1";
    private static final String B_KEY2 = "businessKey2";
    private static final String FAILING_PROCESS = "failing-process";
    private static final String TENANT_ID = "testTenant";
    private static final String CMD_LOGGER = "org.camunda.bpm.engine.cmd";
    private static final String CONTEXT_LOGGER = "org.camunda.bpm.engine.context";
    private static final String JOBEXEC_LOGGER = "org.camunda.bpm.engine.jobexecutor";
    private static final String PVM_LOGGER = "org.camunda.bpm.engine.pvm";
    private static final String LOG_IDENT_FAILURE = "ENGINE-16004";
    private RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
    private boolean defaultEngineRegistered;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return configuration.setLogginContextBusinessKey("businessKey");
        }
    };
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    private RuntimeService runtimeService;
    private TaskService taskService;

    @Before
    public void setupServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.defaultEngineRegistered = false;
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void tearDown() {
        if (this.defaultEngineRegistered) {
            this.runtimeContainerDelegate.unregisterProcessEngine(this.engineRule.getProcessEngine());
        }
    }

    @After
    public void resetLogConfiguration() {
        this.engineRule.getProcessEngineConfiguration().setLogginContextActivityId("activityId").setLogginContextApplicationName("applicationName").setLogginContextBusinessKey("businessKey").setLogginContextProcessDefinitionId("processDefinitionId").setLogginContextProcessInstanceId("processInstanceId").setLogginContextTenantId("tenantId");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm"}, level="DEBUG")
    public void shouldNotLogBusinessKeyIfNotConfigured() {
        this.engineRule.getProcessEngineConfiguration().setLogginContextBusinessKey(null);
        this.manageDeployment(this.modelOneTaskProcess());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogs(instance, "ENGINE-200", Arrays.asList("start", "waitState", "end"), true, false, true, true);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm"}, level="DEBUG")
    public void shouldNotLogDisabledProperties() {
        this.engineRule.getProcessEngineConfiguration().setLogginContextActivityId(null).setLogginContextBusinessKey(null).setLogginContextProcessDefinitionId("");
        this.manageDeployment(this.modelOneTaskProcess());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogs(instance, "ENGINE-200", null, true, false, false, false);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm", "org.camunda.bpm.engine.cmd"}, level="DEBUG")
    public void shouldLogMdcPropertiesOnlyInActivityContext() {
        this.manageDeployment(this.modelOneTaskProcess());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogsPresent(instance, Arrays.asList("start", "waitState", "end"));
        this.assertActivityLogsPresentWithoutMdc("ENGINE-130");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm", "org.camunda.bpm.engine.cmd"}, level="DEBUG")
    public void shouldLogCustomMdcPropertiesOnlyInActivityContext() {
        this.engineRule.getProcessEngineConfiguration().setLogginContextActivityId("actId").setLogginContextApplicationName("appName").setLogginContextBusinessKey("busKey").setLogginContextProcessDefinitionId("defId").setLogginContextProcessInstanceId("instId").setLogginContextTenantId("tenId");
        this.manageDeployment(this.modelOneTaskProcess());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogsPresent(instance, Arrays.asList("start", "waitState", "end"), "actId", "appName", "busKey", "defId", "instId", "tenId");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm"}, level="DEBUG")
    public void shouldLogMdcPropertiesForAsyncBeforeInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").camundaAsyncBefore()).endEvent("end").done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogsPresent(pi, Arrays.asList("start", "waitState", "end"));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.pvm"}, level="DEBUG")
    public void shouldLogMdcPropertiesForAsyncAfterInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").camundaAsyncAfter()).endEvent("end").done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.assertActivityLogsPresent(pi, Arrays.asList("start", "waitState", "end"));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.jobexecutor", "org.camunda.bpm.engine.pvm"}, level="DEBUG")
    public void shouldLogMdcPropertiesForTimerInTaskContext() {
        this.manageDeployment(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").intermediateCatchEvent("timer").timerWithDuration("PT10S")).userTask("waitState").endEvent("end").done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(2L));
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertActivityLogsPresent(pi, Arrays.asList("start", "timer", "waitState", "end"));
        this.assertActivityLogsPresentWithoutMdc("ENGINE-140");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromDelegateInTaskContext() {
        this.manageDeployment(this.modelDelegateFailure());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromDelegateInTaskContextWithChangedBusinessKey() {
        this.manageDeployment(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("bkeyChangingTask").camundaClass(BusinessKeyChangeDelegate.class)).serviceTask("failingTask").camundaClass(FailingDelegate.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, LOG_IDENT_FAILURE, "failingTask", null, B_KEY2, 1);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromCreateTaskListenerInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").userTask("failingTask").camundaTaskListenerClass("create", FailingTaskListener.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromAssignTaskListenerInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("failingTask").camundaTaskListenerClass("assignment", FailingTaskListener.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.setAssignee(((Task)this.taskService.createTaskQuery().singleResult()).getId(), "testUser");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromCompleteTaskListenerInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("failingTask").camundaTaskListenerClass("complete", FailingTaskListener.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromDeleteTaskListenerInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("failingTask").camundaTaskListenerClass("delete", FailingTaskListener.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.runtimeService.deleteProcessInstance(instance.getId(), "cancel it");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromExecutionListenerInTaskContext() {
        this.manageDeployment(this.modelExecutionListenerFailure());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context", "org.camunda.bpm.engine.jobexecutor"}, level="WARN")
    public void shouldLogFailureFromTimeoutTaskListenerInTaskContext() {
        this.manageDeployment(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("failingTask").camundaTaskListenerClassTimeoutWithDuration("failure-listener", FailingTaskListener.class, "PT10S")).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(2L));
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.assertFailureLogPresent(instance, "failingTask", 3);
        this.assertFailureLogPresent(instance, "ENGINE-14006", "failingTask", null, instance.getBusinessKey(), 3);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromParallelTasksInCorrectTaskContext() {
        this.manageDeployment(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").parallelGateway("pSplit").serviceTask("task").camundaClass(NoneDelegate.class)).endEvent("end").moveToLastGateway().serviceTask("failingTask").camundaClass(FailingDelegate.class)).endEvent("failingEnd").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="DEBUG")
    public void shouldLogFailureFromNestedDelegateInOuterContext() {
        this.manageDeployment("failing.bpmn", ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)FAILING_PROCESS).startEvent("failing_start").serviceTask("failing_task").camundaClass(FailingDelegate.class)).endEvent("failing_end").done());
        this.manageDeployment(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("startProcess").camundaClass(NestedStartDelegate.class.getName())).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "startProcess");
        this.assertBpmnStacktraceLogPresent(instance);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="DEBUG")
    public void shouldLogFailureFromNestedExecutionListenerInOuterContext() {
        this.manageDeployment("failing.bpmn", ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)FAILING_PROCESS).startEvent("failing_start").serviceTask("failing_task").camundaClass(NoneDelegate.class.getName())).camundaExecutionListenerClass("end", FailingExecutionListener.class)).endEvent("failing_end").done());
        this.manageDeployment(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("startProcess").camundaClass(NestedStartDelegate.class.getName())).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "startProcess");
        this.assertBpmnStacktraceLogPresent(instance);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromMessageCorrelationListenerInEventContext() {
        this.manageDeployment(((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").intermediateCatchEvent("message").message("testMessage")).camundaExecutionListenerClass("end", FailingExecutionListener.class)).endEvent("end").done());
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.runtimeService.correlateMessage("testMessage");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "message");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromEventSubprocessInSubprocessTaskContext() {
        this.testRule.deployForTenant(TENANT_ID, "org/camunda/bpm/engine/test/logging/ProcessDataLoggingContextTest.shouldLogFailureFromEventSubprocessInSubprocessTaskContext.bpmn20.xml");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS);
        try {
            this.runtimeService.correlateMessage("testMessage");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(instance, "sub_failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogInternalFailureInTaskContext() {
        this.manageDeployment(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("failingTask").camundaDelegateExpression("${foo}")).endEvent("end").done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(pi, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogInputOutputMappingFailureInTaskContext() {
        this.manageDeployment(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("failingTask").camundaClass(NoneDelegate.class)).camundaInputParameter("foo", "${foooo}")).endEvent("end").done());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertFailureLogPresent(pi, "failingTask");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromDelegateInTaskContextInPa() {
        this.registerProcessEngine();
        TestApplicationReusingExistingEngine application = new TestApplicationReusingExistingEngine(){

            public void createDeployment(String processArchiveName, DeploymentBuilder deploymentBuilder) {
                deploymentBuilder.addModelInstance("test.bpmn", ProcessDataLoggingContextTest.this.modelDelegateFailure()).tenantId(ProcessDataLoggingContextTest.TENANT_ID);
            }
        };
        application.deploy();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        application.undeploy();
        this.assertFailureLogInApplication(instance, "failingTask", application.getName());
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.context"}, level="ERROR")
    public void shouldLogFailureFromExecutionListenerInTaskContextInPa() {
        this.registerProcessEngine();
        TestApplicationReusingExistingEngine application = new TestApplicationReusingExistingEngine(){

            public void createDeployment(String processArchiveName, DeploymentBuilder deploymentBuilder) {
                deploymentBuilder.addModelInstance("test.bpmn", ProcessDataLoggingContextTest.this.modelExecutionListenerFailure()).tenantId(ProcessDataLoggingContextTest.TENANT_ID);
            }
        };
        application.deploy();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS, B_KEY);
        try {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        application.undeploy();
        this.assertFailureLogInApplication(instance, "failingTask", application.getName());
    }

    protected void assertActivityLogsPresent(ProcessInstance instance, List<String> expectedActivities) {
        this.assertActivityLogs(instance, "ENGINE-200", expectedActivities, true, true, true, true);
    }

    protected void assertActivityLogsPresentWithoutMdc(String filter) {
        this.assertActivityLogs(null, filter, null, false, false, false, false);
    }

    protected void assertActivityLogs(ProcessInstance instance, String filter, List<String> expectedActivities, boolean isMdcPresent, boolean isBusinessKeyPresent, boolean isActivityIdPresent, boolean isDefinitionIdPresent) {
        this.assertActivityLogs(instance, filter, isActivityIdPresent ? expectedActivities : null, null, isBusinessKeyPresent ? instance.getBusinessKey() : null, isDefinitionIdPresent ? instance.getProcessDefinitionId() : null, isMdcPresent, null);
    }

    protected void assertActivityLogsPresent(ProcessInstance instance, List<String> expectedActivities, String activityIdProperty, String appNameProperty, String businessKeyProperty, String definitionIdProperty, String instanceIdProperty, String tenantIdProperty) {
        this.assertLogs(instance, "ENGINE-200", expectedActivities, null, instance.getBusinessKey(), instance.getProcessDefinitionId(), true, null, activityIdProperty, appNameProperty, businessKeyProperty, definitionIdProperty, instanceIdProperty, tenantIdProperty);
    }

    protected void assertFailureLogPresent(ProcessInstance instance, String activityId) {
        this.assertFailureLogPresent(instance, activityId, 1);
    }

    protected void assertFailureLogPresent(ProcessInstance instance, String activityId, int numberOfFailureLogs) {
        this.assertFailureLogPresent(instance, LOG_IDENT_FAILURE, activityId, null, instance.getBusinessKey(), numberOfFailureLogs);
    }

    protected void assertFailureLogInApplication(ProcessInstance instance, String activityId, String application) {
        this.assertFailureLogPresent(instance, LOG_IDENT_FAILURE, activityId, application, instance.getBusinessKey(), 1);
    }

    protected void assertFailureLogPresent(ProcessInstance instance, String filter, String activityId, String appName, String businessKey, int numberOfFailureLogs) {
        this.assertActivityLogs(instance, filter, Arrays.asList(activityId), appName, businessKey, instance.getProcessDefinitionId(), true, numberOfFailureLogs);
    }

    protected void assertActivityLogs(ProcessInstance instance, String filter, List<String> expectedActivities, String appName, String businessKey, String definitionId, boolean isMdcPresent, Integer numberOfLogs) {
        this.assertLogs(instance, filter, expectedActivities, appName, businessKey, definitionId, isMdcPresent, numberOfLogs, "activityId", "applicationName", "businessKey", "processDefinitionId", "processInstanceId", "tenantId");
    }

    protected void assertLogs(ProcessInstance instance, String filter, List<String> expectedActivities, String appName, String businessKey, String definitionId, boolean isMdcPresent, Integer numberOfLogs, String activityIdProperty, String appNameProperty, String businessKeyProperty, String definitionIdProperty, String instanceIdProperty, String tenantIdProperty) {
        boolean foundLogEntries = false;
        HashSet<String> passedActivities = new HashSet<String>();
        List filteredLog = this.loggingRule.getFilteredLog(filter);
        if (numberOfLogs != null) {
            Assert.assertEquals((long)numberOfLogs.intValue(), (long)filteredLog.size());
        }
        for (ILoggingEvent logEvent : filteredLog) {
            Map mdcPropertyMap = logEvent.getMDCPropertyMap();
            if (isMdcPresent) {
                String activityIdMdc = (String)mdcPropertyMap.get(activityIdProperty);
                String appNameMdc = (String)mdcPropertyMap.get(appNameProperty);
                String businessKeyMdc = (String)mdcPropertyMap.get(businessKeyProperty);
                String definitionIdMdc = (String)mdcPropertyMap.get(definitionIdProperty);
                String instanceIdMdc = (String)mdcPropertyMap.get(instanceIdProperty);
                String tenantIdMdc = (String)mdcPropertyMap.get(tenantIdProperty);
                if (expectedActivities != null) {
                    Assert.assertNotNull((Object)activityIdMdc);
                    Assert.assertTrue((boolean)expectedActivities.contains(activityIdMdc));
                    passedActivities.add(activityIdMdc);
                } else {
                    Assert.assertNull((Object)activityIdMdc);
                }
                if (appName != null) {
                    Assert.assertEquals((Object)appName, (Object)appNameMdc);
                } else {
                    Assert.assertNull((Object)appNameMdc);
                }
                if (businessKey != null) {
                    Assert.assertEquals((Object)businessKey, (Object)businessKeyMdc);
                } else {
                    Assert.assertNull((Object)businessKeyMdc);
                }
                if (definitionId != null) {
                    Assert.assertEquals((Object)definitionId, (Object)definitionIdMdc);
                } else {
                    Assert.assertNull((Object)definitionIdMdc);
                }
                Assert.assertNotNull((Object)instanceIdMdc);
                Assert.assertEquals((Object)instance.getId(), (Object)instanceIdMdc);
                Assert.assertNotNull((Object)tenantIdMdc);
                Assert.assertEquals((Object)instance.getTenantId(), (Object)tenantIdMdc);
            } else {
                Assert.assertTrue((boolean)mdcPropertyMap.isEmpty());
            }
            foundLogEntries = true;
        }
        Assert.assertTrue((boolean)foundLogEntries);
        if (expectedActivities != null) {
            Assert.assertTrue((boolean)passedActivities.equals(new HashSet<String>(expectedActivities)));
        }
    }

    protected void assertBpmnStacktraceLogPresent(ProcessInstance instance) {
        List bpmnStacktraceLog = this.loggingRule.getFilteredLog("ENGINE-16006");
        Assert.assertEquals((long)2L, (long)bpmnStacktraceLog.size());
        for (int i = 0; i < bpmnStacktraceLog.size(); ++i) {
            ILoggingEvent logEvent = (ILoggingEvent)bpmnStacktraceLog.get(i);
            Map mdcPropertyMap = logEvent.getMDCPropertyMap();
            Assert.assertTrue((boolean)mdcPropertyMap.containsKey("activityId"));
            Assert.assertFalse((boolean)mdcPropertyMap.containsKey("applicationName"));
            Assert.assertTrue((boolean)mdcPropertyMap.containsKey("processDefinitionId"));
            Assert.assertTrue((boolean)mdcPropertyMap.containsKey("processInstanceId"));
            Assert.assertTrue((boolean)mdcPropertyMap.containsKey("tenantId"));
            if (i == 0) {
                Assert.assertFalse((boolean)mdcPropertyMap.containsKey("businessKey"));
                Assert.assertEquals((Object)"failing_task", mdcPropertyMap.get("activityId"));
                Assert.assertNotEquals((Object)instance.getProcessDefinitionId(), mdcPropertyMap.get("processDefinitionId"));
                Assert.assertNotEquals((Object)instance.getId(), mdcPropertyMap.get("processInstanceId"));
                Assert.assertEquals((Object)instance.getTenantId(), mdcPropertyMap.get("tenantId"));
                continue;
            }
            Assert.assertTrue((boolean)mdcPropertyMap.containsKey("businessKey"));
            Assert.assertEquals((Object)"startProcess", mdcPropertyMap.get("activityId"));
            Assert.assertEquals((Object)instance.getBusinessKey(), mdcPropertyMap.get("businessKey"));
            Assert.assertEquals((Object)instance.getProcessDefinitionId(), mdcPropertyMap.get("processDefinitionId"));
            Assert.assertEquals((Object)instance.getId(), mdcPropertyMap.get("processInstanceId"));
            Assert.assertEquals((Object)instance.getTenantId(), mdcPropertyMap.get("tenantId"));
        }
    }

    protected void manageDeployment(BpmnModelInstance model) {
        this.manageDeployment("test.bpmn", model);
    }

    protected void manageDeployment(String name, BpmnModelInstance model) {
        this.testRule.deployForTenant(TENANT_ID, model);
    }

    protected void registerProcessEngine() {
        this.runtimeContainerDelegate.registerProcessEngine(this.engineRule.getProcessEngine());
        this.defaultEngineRegistered = true;
    }

    protected BpmnModelInstance modelOneTaskProcess() {
        return Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").endEvent("end").done();
    }

    protected BpmnModelInstance modelDelegateFailure() {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("waitState").serviceTask("failingTask").camundaClass(FailingDelegate.class)).endEvent("end").done();
    }

    protected BpmnModelInstance modelExecutionListenerFailure() {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").userTask("failingTask").camundaExecutionListenerClass("end", FailingExecutionListener.class)).endEvent("end").done();
    }

    public static class FailingExecutionListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) {
            throw new IllegalArgumentException("I am failing!");
        }
    }

    public static class FailingTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            throw new IllegalArgumentException("I am failing!");
        }
    }

    public static class BusinessKeyChangeDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setProcessBusinessKey(ProcessDataLoggingContextTest.B_KEY2);
        }
    }

    public static class NoneDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
        }
    }

    public static class FailingDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            throw new IllegalArgumentException("I am always failing!");
        }
    }

    public static class NestedStartDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngine().getRuntimeService();
            runtimeService.startProcessInstanceByKey(ProcessDataLoggingContextTest.FAILING_PROCESS, (String)null);
        }
    }
}

