/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.persistence;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class DatabaseFlushTest
extends ConcurrencyTestCase {
    public static final BpmnModelInstance GW_PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway().userTask("task1-1").userTask("task1-2").endEvent().moveToLastGateway().userTask("task2-1").userTask("task2-2").endEvent().done();

    @RequiredDatabase(excludes={"db2"})
    public void testNoIncompleteFlushOnConstraintViolation() {
        this.deployment(new BpmnModelInstance[]{GW_PROCESS});
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        VariableMap variables = Variables.createVariables().putValue("key1", (Object)"val1").putValue("key2", (Object)"val2").putValue("key3", (Object)"val3");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new CompleteTaskCommand(task1.getId(), variables));
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new CompleteTaskCommand(task2.getId(), variables));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.waitUntilDone();
        thread2.waitUntilDone();
        Assertions.assertThat((Throwable)thread2.getException()).isInstanceOf(OptimisticLockingException.class);
        task2 = (Task)this.taskService.createTaskQuery().taskId(task2.getId()).singleResult();
        Assertions.assertThat((Object)task2).isNotNull();
    }

    private static class CompleteTaskCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String taskId;
        protected VariableMap variables;

        public CompleteTaskCommand(String taskId, VariableMap variables) {
            this.taskId = taskId;
            this.variables = variables;
        }

        public Void execute(CommandContext commandContext) {
            CompleteTaskCmd completeTaskCmd = new CompleteTaskCmd(this.taskId, (Map)this.variables);
            completeTaskCmd.execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

