/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.test.standalone.db.SchemaLogTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SchemaLogUpgradeScriptPatternTest
extends SchemaLogTestCase {
    @Test
    public void testOnlyValidUpgradeFilePatterns() {
        for (String file : (List)this.folderContents.get("org/camunda/bpm/engine/db/upgrade")) {
            Assert.assertTrue((String)("unexpected file format for file: " + file), (boolean)file.endsWith(".sql"));
            file = file.substring(0, file.length() - 4);
            String[] nameParts = file.split("_");
            Assert.assertThat((Object)nameParts[0], (Matcher)Matchers.isOneOf((Object[])DATABASES));
            Assert.assertThat((Object)nameParts[1], (Matcher)CoreMatchers.is((Object)"engine"));
            String minorVersion = nameParts[2];
            Assert.assertTrue((boolean)this.isMinorLevel(minorVersion));
            if (nameParts[3].equals("to")) {
                Assert.assertThat((Object)nameParts[4], (Matcher)Matchers.isOneOf((Object[])this.getPossibleNextVersions(minorVersion)));
                Assert.assertThat((Object)nameParts.length, (Matcher)CoreMatchers.is((Object)5));
                continue;
            }
            if (nameParts[3].equals("patch")) {
                String basePatchVersion = nameParts[4];
                Assert.assertTrue((String)("unexpected patch version pattern for file: " + file), (boolean)this.isPatchLevel(basePatchVersion));
                Assert.assertThat((Object)minorVersion, (Matcher)CoreMatchers.is((Object)this.getMinorLevelFromPatchVersion(basePatchVersion)));
                Assert.assertThat((Object)nameParts[5], (Matcher)CoreMatchers.is((Object)"to"));
                Assert.assertThat((Object)nameParts[6], (Matcher)Matchers.isOneOf((Object[])this.getPossibleNextVersions(basePatchVersion)));
                if (nameParts.length == 8) {
                    Integer.parseInt(nameParts[7]);
                    continue;
                }
                Assert.assertThat((Object)nameParts.length, (Matcher)CoreMatchers.is((Object)7));
                continue;
            }
            Assert.fail((String)("unexpected pattern for file: " + file));
        }
    }

    private String getMinorLevelFromPatchVersion(String minorVersion) {
        Object[] versionParts = minorVersion.split("\\.");
        return StringUtils.join((Object[])versionParts, (String)".", (int)0, (int)2);
    }

    private String[] getPossibleNextVersions(String version) {
        ArrayList<String> versions = new ArrayList<String>();
        String[] versionParts = version.split("\\.");
        if (this.isPatchLevel(version)) {
            versions.add(versionParts[0] + "." + versionParts[1] + "." + (Integer.parseInt(versionParts[2]) + 1));
        } else if (this.isMinorLevel(version)) {
            versions.add(versionParts[0] + "." + (Integer.parseInt(versionParts[1]) + 1));
            versions.add(Integer.parseInt(versionParts[0]) + 1 + ".0");
        } else {
            Assert.fail((String)("unexpected pattern for version: " + version));
        }
        return versions.toArray(new String[0]);
    }
}

