/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class ScriptCompilationTest
extends PluggableProcessEngineTestCase {
    protected static final String SCRIPT_LANGUAGE = "groovy";
    protected static final String EXAMPLE_SCRIPT = "println 'hello world'";
    protected ScriptFactory scriptFactory;

    public void setUp() {
        this.scriptFactory = this.processEngineConfiguration.getScriptFactory();
    }

    protected SourceExecutableScript createScript(String language, String source) {
        return (SourceExecutableScript)this.scriptFactory.createScriptFromSource(language, source);
    }

    public void testScriptShouldBeCompiledByDefault() {
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        ScriptCompilationTest.assertNotNull((Object)script);
        ScriptCompilationTest.assertTrue((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        ScriptCompilationTest.assertFalse((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNotNull((Object)script.getCompiledScript());
    }

    public void testDisableScriptCompilation() {
        this.processEngineConfiguration.setEnableScriptCompilation(false);
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        ScriptCompilationTest.assertNotNull((Object)script);
        ScriptCompilationTest.assertTrue((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        ScriptCompilationTest.assertFalse((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.processEngineConfiguration.setEnableScriptCompilation(true);
    }

    public void testDisableScriptCompilationByDisabledScriptEngineCaching() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        ScriptCompilationTest.assertNotNull((Object)script);
        ScriptCompilationTest.assertTrue((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        ScriptCompilationTest.assertFalse((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
    }

    public void testOverrideScriptSource() {
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        ScriptCompilationTest.assertNotNull((Object)script);
        this.executeScript((ExecutableScript)script);
        ScriptCompilationTest.assertFalse((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNotNull((Object)script.getCompiledScript());
        script.setScriptSource(EXAMPLE_SCRIPT);
        ScriptCompilationTest.assertTrue((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        ScriptCompilationTest.assertFalse((boolean)script.isShouldBeCompiled());
        ScriptCompilationTest.assertNotNull((Object)script.getCompiledScript());
    }

    protected Object executeScript(final ExecutableScript script) {
        final ScriptingEnvironment scriptingEnvironment = this.processEngineConfiguration.getScriptingEnvironment();
        return this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                return scriptingEnvironment.execute(script, null);
            }
        });
    }
}

