/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskReadVariablePermissionAuthorizationTest {
    private static final String PROCESS_KEY = "oneTaskProcess";
    private static final String DEMO = "demo";
    private static final String ACCOUNTING_GROUP = "accounting";
    protected static String userId = "test";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private IdentityService identityService;
    private AuthorizationService authorizationService;
    private TaskService taskService;
    private RuntimeService runtimeService;
    private boolean enforceSpecificVariablePermission;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.enforceSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        this.identityService.setAuthenticatedUserId(userId);
        this.authRule.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*", userId, new Permission[]{Permissions.CREATE});
    }

    @After
    public void cleanUp() {
        this.authRule.disableAuthorization();
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{DEMO}).list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{ACCOUNTING_GROUP}).list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.enforceSpecificVariablePermission);
    }

    @Test
    public void testSaveStandaloneTaskAndCheckAssigneePermissions() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        task.setAssignee(DEMO);
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)DEMO, (Object)task.getAssignee());
        this.verifyUserAuthorization(DEMO);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSaveProcessTaskAndCheckAssigneePermissions() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee(DEMO);
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, task.getId(), userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)DEMO, (Object)task.getAssignee());
        this.verifyUserAuthorization(DEMO);
    }

    @Test
    public void testStandaloneTaskSetOwnerAndCheckOwnerPermissions() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, DEMO);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)DEMO, (Object)task.getOwner());
        this.verifyUserAuthorization(DEMO);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessTaskSetOwnerAndCheckOwnerPermissions() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, DEMO);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)DEMO, (Object)task.getOwner());
        this.verifyUserAuthorization(DEMO);
    }

    @Test
    public void testStandaloneTaskAddUserIdentityLinkAndUserOwnerPermissions() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, DEMO, "candidate");
        this.authRule.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.authRule.disableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)DEMO, (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.verifyUserAuthorization(DEMO);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, DEMO, "candidate");
        this.authRule.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.authRule.disableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)DEMO, (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.verifyUserAuthorization(DEMO);
    }

    @Test
    public void testStandaloneTaskAddGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, ACCOUNTING_GROUP, "candidate");
        this.authRule.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.authRule.disableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)ACCOUNTING_GROUP, (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.verifyGroupAuthorization(ACCOUNTING_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.authRule.createGrantAuthorization((Resource)Resources.TASK, taskId, userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, ACCOUNTING_GROUP, "candidate");
        this.authRule.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.authRule.disableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)ACCOUNTING_GROUP, (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.verifyGroupAuthorization(ACCOUNTING_GROUP);
    }

    protected void createTask(String taskId) {
        this.authRule.disableAuthorization();
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.authRule.enableAuthorization(userId);
    }

    protected Task selectSingleTask() {
        this.authRule.disableAuthorization();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.authRule.enableAuthorization(userId);
        return task;
    }

    protected void startProcessInstanceByKey(String processKey) {
        this.authRule.disableAuthorization();
        this.runtimeService.startProcessInstanceByKey(processKey);
        this.authRule.enableAuthorization(userId);
    }

    protected void verifyUserAuthorization(String userId) {
        this.authRule.disableAuthorization();
        Authorization userAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertNotNull((Object)userAuthorization);
        this.verifyReadVariablePermission(userAuthorization);
    }

    protected void verifyGroupAuthorization(String groupId) {
        this.authRule.disableAuthorization();
        Authorization groupAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{groupId}).singleResult();
        Assert.assertNotNull((Object)groupAuthorization);
        this.verifyReadVariablePermission(groupAuthorization);
    }

    protected void verifyReadVariablePermission(Authorization groupAuthorization) {
        Permission[] permissions = groupAuthorization.getPermissions(new Permission[]{TaskPermissions.READ_VARIABLE});
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((Object)TaskPermissions.READ_VARIABLE, (Object)permissions[0]);
    }
}

