/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.task.updatevariable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProcessTaskAuthorizationTest {
    private static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String userId = "userId";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    protected static final String PROCESS_KEY = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected RuntimeService runtimeService;
    protected boolean ensureSpecificVariablePermission;
    protected String deploumentId;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.UPDATE_TASK}), AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", userId, new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{Permissions.UPDATE_TASK})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", userId, new Permission[]{Permissions.UPDATE_TASK})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE})).succeeds());
    }

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authRule.createUserAndGroup(userId, "groupId");
        this.deploumentId = this.engineRule.getRepositoryService().createDeployment().addClasspathResource(ONE_TASK_PROCESS).deployWithResult().getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
        this.engineRule.getRepositoryService().deleteDeployment(this.deploumentId, true);
    }

    @Test
    public void testSetVariable() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.setVariable(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariableLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.setVariableLocal(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariables() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariablesLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariable() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.removeVariable(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariableLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.removeVariableLocal(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariables() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.removeVariables(taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariablesLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        this.taskService.removeVariablesLocal(taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesAdd() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesRemove() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesAddRemove() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalAdd() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalRemove() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalAddRemove() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariables();
        }
    }

    protected void verifySetVariables() {
        this.verifyVariableInstanceCount(1);
        Assert.assertNotNull((Object)this.runtimeService.createVariableInstanceQuery().singleResult());
    }

    protected void verifyRemoveVariables() {
        this.verifyVariableInstanceCount(0);
        Assert.assertNull((Object)this.runtimeService.createVariableInstanceQuery().singleResult());
        HistoricVariableInstance deletedVariable = (HistoricVariableInstance)this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().includeDeleted().singleResult();
        Assert.assertEquals((Object)"DELETED", (Object)deletedVariable.getState());
    }

    protected void verifyVariableInstanceCount(int count) {
        Assert.assertEquals((long)count, (long)this.runtimeService.createVariableInstanceQuery().list().size());
        Assert.assertEquals((long)count, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }
}

