/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.form.Address;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.commons.utils.IoUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class FormServiceTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private HistoryService historyService;
    private IdentityService identityService;
    private FormService formService;
    private CaseService caseService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.formService = this.engineRule.getFormService();
        this.caseService = this.engineRule.getCaseService();
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("fozzie", "management");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/approve.form", "org/camunda/bpm/engine/test/api/form/util/request.form", "org/camunda/bpm/engine/test/api/form/util/adjustRequest.form"})
    @Test
    public void testGetStartFormByProcessDefinitionId() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId(), "juel");
        Assert.assertNotNull((Object)startForm);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetStartFormByProcessDefinitionIdWithoutStartform() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId());
        Assert.assertNull((Object)startForm);
    }

    @Test
    public void testGetStartFormByKeyNullKey() {
        try {
            this.formService.getRenderedStartForm(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStartFormByIdNullId() {
        try {
            this.formService.getRenderedStartForm(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStartFormByIdUnexistingProcessDefinitionId() {
        try {
            this.formService.getRenderedStartForm("unexistingId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    @Test
    public void testGetTaskFormNullTaskId() {
        try {
            this.formService.getRenderedTaskForm(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTaskFormUnexistingTaskId() {
        try {
            this.formService.getRenderedTaskForm("unexistingtask");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Task 'unexistingtask' not found", ae.getMessage());
        }
    }

    @Test
    public void testTaskFormPropertyDefaultsAndFormRendering() {
        String deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form").getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startForm = this.formService.getStartFormData(procDefId);
        Assert.assertNotNull((Object)startForm);
        Assert.assertEquals((Object)deploymentId, (Object)startForm.getDeploymentId());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/api/form/start.form", (Object)startForm.getFormKey());
        Assert.assertEquals(new ArrayList(), (Object)startForm.getFormProperties());
        Assert.assertEquals((Object)procDefId, (Object)startForm.getProcessDefinition().getId());
        Object renderedStartForm = this.formService.getRenderedStartForm(procDefId, "juel");
        Assert.assertEquals((Object)"start form content", (Object)renderedStartForm);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("speaker", "Mike");
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertEquals(expectedVariables, (Object)variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        TaskFormData taskForm = this.formService.getTaskFormData(taskId);
        Assert.assertEquals((Object)deploymentId, (Object)taskForm.getDeploymentId());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/api/form/task.form", (Object)taskForm.getFormKey());
        Assert.assertEquals(new ArrayList(), (Object)taskForm.getFormProperties());
        Assert.assertEquals((Object)taskId, (Object)taskForm.getTask().getId());
        Assert.assertEquals((Object)"Mike is speaking in room 5b", (Object)this.formService.getRenderedTaskForm(taskId, "juel"));
        properties = new HashMap();
        properties.put("room", "3f");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "3f");
        expectedVariables.put("speaker", "Mike");
        variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    @Test
    public void testFormPropertyHandlingDeprecated() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", "45");
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        Assert.assertEquals((Object)"room", (Object)propertyRoom.getId());
        Assert.assertEquals((Object)"5b", (Object)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        Assert.assertEquals((Object)"duration", (Object)propertyDuration.getId());
        Assert.assertEquals((Object)"45", (Object)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        Assert.assertEquals((Object)"speaker", (Object)propertySpeaker.getId());
        Assert.assertEquals((Object)"Mike", (Object)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        Assert.assertEquals((Object)"street", (Object)propertyStreet.getId());
        Assert.assertEquals((Object)"broadway", (Object)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        Assert.assertEquals((Object)"free", (Object)propertyFree.getId());
        Assert.assertEquals((Object)"true", (Object)propertyFree.getValue());
        Assert.assertEquals((long)5L, (long)formProperties.size());
        try {
            this.formService.submitTaskFormData(taskId, new HashMap());
            Assert.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskFormData(taskId, properties);
            Assert.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        Assert.assertEquals((Object)"rubensstraat", (Object)address.getStreet());
        Assert.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    @Test
    public void testFormPropertyHandling() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", 45L);
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartForm(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        Assert.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        Assert.assertEquals((Object)"room", (Object)propertyRoom.getId());
        Assert.assertEquals((Object)"5b", (Object)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        Assert.assertEquals((Object)"duration", (Object)propertyDuration.getId());
        Assert.assertEquals((Object)"45", (Object)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        Assert.assertEquals((Object)"speaker", (Object)propertySpeaker.getId());
        Assert.assertEquals((Object)"Mike", (Object)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        Assert.assertEquals((Object)"street", (Object)propertyStreet.getId());
        Assert.assertEquals((Object)"broadway", (Object)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        Assert.assertEquals((Object)"free", (Object)propertyFree.getId());
        Assert.assertEquals((Object)"true", (Object)propertyFree.getValue());
        Assert.assertEquals((long)5L, (long)formProperties.size());
        try {
            this.formService.submitTaskForm(taskId, new HashMap());
            Assert.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskForm(taskId, properties);
            Assert.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskForm(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        Assert.assertEquals((Object)"rubensstraat", (Object)address.getStreet());
        Assert.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    @Test
    public void testFormPropertyDetails() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startFormData = this.formService.getStartFormData(procDefId);
        FormProperty property = (FormProperty)startFormData.getFormProperties().get(0);
        Assert.assertEquals((Object)"speaker", (Object)property.getId());
        Assert.assertNull((Object)property.getValue());
        Assert.assertTrue((boolean)property.isReadable());
        Assert.assertTrue((boolean)property.isWritable());
        Assert.assertFalse((boolean)property.isRequired());
        Assert.assertEquals((Object)"string", (Object)property.getType().getName());
        property = (FormProperty)startFormData.getFormProperties().get(1);
        Assert.assertEquals((Object)"start", (Object)property.getId());
        Assert.assertNull((Object)property.getValue());
        Assert.assertTrue((boolean)property.isReadable());
        Assert.assertTrue((boolean)property.isWritable());
        Assert.assertFalse((boolean)property.isRequired());
        Assert.assertEquals((Object)"date", (Object)property.getType().getName());
        Assert.assertEquals((Object)"dd-MMM-yyyy", (Object)property.getType().getInformation("datePattern"));
        property = (FormProperty)startFormData.getFormProperties().get(2);
        Assert.assertEquals((Object)"direction", (Object)property.getId());
        Assert.assertNull((Object)property.getValue());
        Assert.assertTrue((boolean)property.isReadable());
        Assert.assertTrue((boolean)property.isWritable());
        Assert.assertFalse((boolean)property.isRequired());
        Assert.assertEquals((Object)"enum", (Object)property.getType().getName());
        Map values = (Map)property.getType().getInformation("values");
        LinkedHashMap<String, String> expectedValues = new LinkedHashMap<String, String>();
        expectedValues.put("left", "Go Left");
        expectedValues.put("right", "Go Right");
        expectedValues.put("up", "Go Up");
        expectedValues.put("down", "Go Down");
        Iterator expectedValuesIterator = expectedValues.entrySet().iterator();
        for (Map.Entry entry : values.entrySet()) {
            Map.Entry expectedEntryAtLocation = expectedValuesIterator.next();
            Assert.assertEquals(expectedEntryAtLocation.getKey(), entry.getKey());
            Assert.assertEquals(expectedEntryAtLocation.getValue(), entry.getValue());
        }
        Assert.assertEquals(expectedValues, (Object)values);
    }

    @Deployment
    @Test
    public void testInvalidFormKeyReference() {
        try {
            this.formService.getRenderedStartForm(((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId(), "juel");
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Form with formKey 'IDoNotExist' does not exist", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testSubmitStartFormDataWithBusinessKey() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("duration", "45");
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDefId, "123", properties);
        Assert.assertEquals((Object)"123", (Object)processInstance.getBusinessKey());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    @Test
    public void testSubmitStartFormDataTypedVariables() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String stringValue = "some string";
        String serializedValue = "some value";
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        Assert.assertEquals((Object)Variables.booleanValue(null), (Object)variables.getValueTyped("boolean"));
        Assert.assertEquals((Object)Variables.stringValue((String)stringValue), (Object)variables.getValueTyped("string"));
        Assert.assertNotNull((Object)((ObjectValue)variables.getValueTyped("serializedObject")).getValueSerialized());
        Assert.assertNotNull((Object)((ObjectValue)variables.getValueTyped("object")).getValueSerialized());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormDataTypedVariables() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, (Map)Variables.createVariables());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String stringValue = "some string";
        String serializedValue = "some value";
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        Assert.assertEquals((Object)Variables.booleanValue(null), (Object)variables.getValueTyped("boolean"));
        Assert.assertEquals((Object)Variables.stringValue((String)stringValue), (Object)variables.getValueTyped("string"));
        Assert.assertNotNull((Object)((ObjectValue)variables.getValueTyped("serializedObject")).getValueSerialized());
        Assert.assertNotNull((Object)((ObjectValue)variables.getValueTyped("object")).getValueSerialized());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    @Test
    public void testSubmitFormVariablesNull() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.formService.submitStartForm(procDefId, null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.formService.submitTaskForm(task.getId(), null);
    }

    @Test
    public void testSubmitTaskFormForStandaloneTask() {
        String id = "standaloneTask";
        Task task = this.taskService.newTask(id);
        this.taskService.saveTask(task);
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{id}).singleResult();
            Assert.assertNotNull((Object)variableInstance);
            Assert.assertEquals((Object)"foo", (Object)variableInstance.getName());
            Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
        }
        this.taskService.deleteTask(id, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSubmitTaskFormForCmmnHumanTask() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String stringValue = "some string";
        String serializedValue = "some value";
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
    }

    @Deployment
    @Test
    public void testSubmitStartFormWithBusinessKey() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        Assert.assertEquals((Object)"123", (Object)processInstance.getBusinessKey());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)"Mike", variables.get("SpeakerName"));
        Assert.assertEquals((Object)45L, variables.get("duration"));
    }

    @Deployment
    @Test
    public void testSubmitStartFormWithoutProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        Assert.assertEquals((Object)"123", (Object)processInstance.getBusinessKey());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)"Mike", variables.get("speaker"));
        Assert.assertEquals((Object)45L, variables.get("duration"));
    }

    @Test
    public void testGetStartFormKeyEmptyArgument() {
        try {
            this.formService.getStartFormKey(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getStartFormKey("");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    @Test
    public void testGetStartFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String expectedFormKey = this.formService.getStartFormData(processDefinitionId).getFormKey();
        String actualFormKey = this.formService.getStartFormKey(processDefinitionId);
        Assert.assertEquals((Object)expectedFormKey, (Object)actualFormKey);
    }

    @Test
    public void testGetTaskFormKeyEmptyArguments() {
        try {
            this.formService.getTaskFormKey(null, "23");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("", "23");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The task definition key is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", "");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The task definition key is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    @Test
    public void testGetTaskFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        String expectedFormKey = this.formService.getTaskFormData(task.getId()).getFormKey();
        String actualFormKey = this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        Assert.assertEquals((Object)expectedFormKey, (Object)actualFormKey);
    }

    @Deployment
    @Test
    public void testGetTaskFormKeyWithExpression() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess", CollectionUtil.singletonMap((String)"dynamicKey", (Object)"test"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"test", (Object)this.formService.getTaskFormData(task.getId()).getFormKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFields.bpmn20.xml"})
    @Test
    public void testGetStartFormVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        VariableMap variables = this.formService.getStartFormVariables(processDefinition.getId());
        Assert.assertEquals((long)4L, (long)variables.size());
        Assert.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        Assert.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        Assert.assertEquals((Object)5L, (Object)variables.get((Object)"longField"));
        Assert.assertEquals((Object)5L, (Object)variables.getValueTyped("longField").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("longField").getType());
        Assert.assertNull((Object)variables.get((Object)"customField"));
        Assert.assertNull((Object)variables.getValueTyped("customField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("customField").getType());
        Assert.assertNotNull((Object)variables.get((Object)"dateField"));
        Assert.assertEquals((Object)variables.get((Object)"dateField"), (Object)variables.getValueTyped("dateField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("dateField").getType());
        AbstractFormFieldType dateFormType = this.processEngineConfiguration.getFormTypes().getFormType("date");
        Date dateValue = (Date)dateFormType.convertToModelValue(variables.getValueTyped("dateField")).getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        Assert.assertEquals((long)10L, (long)calendar.get(5));
        Assert.assertEquals((long)0L, (long)calendar.get(2));
        Assert.assertEquals((long)2013L, (long)calendar.get(1));
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("stringField"), true);
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        Assert.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("non-existing!"), true);
        Assert.assertEquals((long)0L, (long)variables.size());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), null, true);
        Assert.assertEquals((long)4L, (long)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFieldsUnknownType.bpmn20.xml"})
    @Test
    public void testGetStartFormVariablesEnumType() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        VariableMap startFormVariables = this.formService.getStartFormVariables(processDefinition.getId());
        Assert.assertEquals((Object)"a", (Object)startFormVariables.get((Object)"enumField"));
        Assert.assertEquals((Object)ValueType.STRING, (Object)startFormVariables.getValueTyped("enumField").getType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.taskFormFields.bpmn20.xml"})
    @Test
    public void testGetTaskFormVariables() {
        HashMap<String, Object> processVars = new HashMap<String, Object>();
        processVars.put("someString", "initialValue");
        processVars.put("initialBooleanVariable", true);
        processVars.put("initialLongVariable", 1L);
        processVars.put("serializable", Arrays.asList("a", "b", "c"));
        this.runtimeService.startProcessInstanceByKey("testProcess", processVars);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap variables = this.formService.getTaskFormVariables(task.getId());
        Assert.assertEquals((long)7L, (long)variables.size());
        Assert.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        Assert.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        Assert.assertEquals((Object)5L, (Object)variables.get((Object)"longField"));
        Assert.assertEquals((Object)5L, (Object)variables.getValueTyped("longField").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("longField").getType());
        Assert.assertNull((Object)variables.get((Object)"customField"));
        Assert.assertNull((Object)variables.getValueTyped("customField").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("customField").getType());
        Assert.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        Assert.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        Assert.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        Assert.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        Assert.assertEquals((Object)1L, (Object)variables.get((Object)"initialLongVariable"));
        Assert.assertEquals((Object)1L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        Assert.assertNotNull((Object)variables.get((Object)"serializable"));
        this.taskService.setVariableLocal(task.getId(), "initialLongVariable", (Object)2L);
        variables = this.formService.getTaskFormVariables(task.getId());
        Assert.assertEquals((long)7L, (long)variables.size());
        Assert.assertEquals((Object)2L, (Object)variables.get((Object)"initialLongVariable"));
        Assert.assertEquals((Object)2L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("someString"), true);
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        Assert.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("initialBooleanVariable"), true);
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        Assert.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("non-existing!"), true);
        Assert.assertEquals((long)0L, (long)variables.size());
        variables = this.formService.getTaskFormVariables(task.getId(), null, true);
        Assert.assertEquals((long)7L, (long)variables.size());
    }

    @Test
    public void testGetTaskFormVariables_StandaloneTask() {
        HashMap<String, Object> processVars = new HashMap<String, Object>();
        processVars.put("someString", "initialValue");
        processVars.put("initialBooleanVariable", true);
        processVars.put("initialLongVariable", 1L);
        processVars.put("serializable", Arrays.asList("a", "b", "c"));
        Task standaloneTask = this.taskService.newTask();
        standaloneTask.setName("A Standalone Task");
        this.taskService.saveTask(standaloneTask);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), processVars);
        VariableMap variables = this.formService.getTaskFormVariables(task.getId());
        Assert.assertEquals((long)4L, (long)variables.size());
        Assert.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        Assert.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        Assert.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        Assert.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        Assert.assertEquals((Object)1L, (Object)variables.get((Object)"initialLongVariable"));
        Assert.assertEquals((Object)1L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        Assert.assertNotNull((Object)variables.get((Object)"serializable"));
        this.taskService.setVariable(task.getId(), "initialLongVariable", (Object)2L);
        variables = this.formService.getTaskFormVariables(task.getId());
        Assert.assertEquals((long)4L, (long)variables.size());
        Assert.assertEquals((Object)2L, (Object)variables.get((Object)"initialLongVariable"));
        Assert.assertEquals((Object)2L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        Assert.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("someString"), true);
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        Assert.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("non-existing!"), true);
        Assert.assertEquals((long)0L, (long)variables.size());
        variables = this.formService.getTaskFormVariables(task.getId(), null, true);
        Assert.assertEquals((long)4L, (long)variables.size());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubmitStartFormWithObjectVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap variables = new HashMap();
        variables.put("var", new ArrayList());
        ProcessInstance processInstance = this.formService.submitStartForm(processDefinition.getId(), variables);
        ArrayList var = (ArrayList)this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isEmpty());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formFields().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormWithObjectVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        HashMap variables = new HashMap();
        variables.put("var", new ArrayList());
        this.formService.submitTaskForm(task.getId(), variables);
        ArrayList var = (ArrayList)this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isEmpty());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formFields().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskServiceTest.testCompleteTaskWithVariablesInReturn.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormWithVariablesInReturn() {
        String processVarName = "processVar";
        String processVarValue = "processVarValue";
        String taskVarName = "taskVar";
        String taskVarValue = "taskVarValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(processVarName, processVarValue);
        this.runtimeService.startProcessInstanceByKey("TaskServiceTest.testCompleteTaskWithVariablesInReturn", variables);
        Task firstUserTask = (Task)this.taskService.createTaskQuery().taskName("First User Task").singleResult();
        this.taskService.setVariable(firstUserTask.getId(), "x", (Object)1);
        HashMap<String, Object> additionalVariables = new HashMap<String, Object>();
        additionalVariables.put(taskVarName, taskVarValue);
        VariableMap vars = this.formService.submitTaskFormWithVariablesInReturn(firstUserTask.getId(), additionalVariables, true);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)5, (Object)vars.get((Object)"x"));
        Assert.assertEquals((Object)ValueType.INTEGER, (Object)vars.getValueTyped("x").getType());
        Assert.assertEquals((Object)processVarValue, (Object)vars.get((Object)processVarName));
        Assert.assertEquals((Object)ValueType.STRING, (Object)vars.getValueTyped(processVarName).getType());
        Assert.assertEquals((Object)taskVarValue, (Object)vars.get((Object)taskVarName));
        additionalVariables = new HashMap();
        additionalVariables.put("x", 7);
        Task secondUserTask = (Task)this.taskService.createTaskQuery().taskName("Second User Task").singleResult();
        vars = this.formService.submitTaskFormWithVariablesInReturn(secondUserTask.getId(), additionalVariables, true);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)7, (Object)vars.get((Object)"x"));
        Assert.assertEquals((Object)processVarValue, (Object)vars.get((Object)processVarName));
        Assert.assertEquals((Object)taskVarValue, (Object)vars.get((Object)taskVarName));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoParallelTasksProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormWithVariablesInReturnParallel() {
        String processVarName = "processVar";
        String processVarValue = "processVarValue";
        String task1VarName = "taskVar1";
        String task2VarName = "taskVar2";
        String task1VarValue = "taskVarValue1";
        String task2VarValue = "taskVarValue2";
        String additionalVar = "additionalVar";
        String additionalVarValue = "additionalVarValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(processVarName, processVarValue);
        this.runtimeService.startProcessInstanceByKey("twoParallelTasksProcess", variables);
        Task firstTask = (Task)this.taskService.createTaskQuery().taskName("First Task").singleResult();
        this.taskService.setVariable(firstTask.getId(), task1VarName, (Object)task1VarValue);
        Task secondTask = (Task)this.taskService.createTaskQuery().taskName("Second Task").singleResult();
        this.taskService.setVariable(secondTask.getId(), task2VarName, (Object)task2VarValue);
        VariableMap vars = this.formService.submitTaskFormWithVariablesInReturn(firstTask.getId(), null, true);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)processVarValue, vars.get(processVarName));
        Assert.assertEquals((Object)task1VarValue, vars.get(task1VarName));
        Assert.assertEquals((Object)task2VarValue, vars.get(task2VarName));
        HashMap<String, String> additionalVariables = new HashMap<String, String>();
        additionalVariables.put(additionalVar, additionalVarValue);
        vars = this.formService.submitTaskFormWithVariablesInReturn(secondTask.getId(), additionalVariables, true);
        Assert.assertEquals((long)4L, (long)vars.size());
        Assert.assertEquals((Object)processVarValue, vars.get(processVarName));
        Assert.assertEquals((Object)task1VarValue, vars.get(task1VarName));
        Assert.assertEquals((Object)task2VarValue, vars.get(task2VarName));
        Assert.assertEquals((Object)additionalVarValue, vars.get(additionalVar));
    }

    @Test
    public void testSubmitTaskFormAndDoNotDeserializeVariables() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().userTask("task1").userTask("task2").endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"var", (Object)"val"));
        final Task task = (Task)this.taskService.createTaskQuery().singleResult();
        boolean hasLoadedAnyVariables = (Boolean)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Boolean>(){

            public Boolean execute(CommandContext commandContext) {
                FormServiceTest.this.formService.submitTaskForm(task.getId(), null);
                return !commandContext.getDbEntityManager().getCachedEntitiesByType(VariableInstanceEntity.class).isEmpty();
            }
        });
        Assertions.assertThat((boolean)hasLoadedAnyVariables).isFalse();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testSubmitTaskFormWithVarialbesInReturnShouldDeserializeObjectValue() {
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap result = this.formService.submitTaskFormWithVariablesInReturn(task.getId(), null, true);
        ObjectValue returnedValue = (ObjectValue)result.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isTrue();
        Assertions.assertThat((Object)returnedValue.getValue()).isEqualTo((Object)"value");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testSubmitTaskFormWithVarialbesInReturnShouldNotDeserializeObjectValue() {
        ObjectValue value = (ObjectValue)Variables.objectValue((Object)"value").create();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)value);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)variables);
        String serializedValue = ((ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "var")).getValueSerialized();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap result = this.formService.submitTaskFormWithVariablesInReturn(task.getId(), null, false);
        ObjectValue returnedValue = (ObjectValue)result.getValueTyped("var");
        Assertions.assertThat((boolean)returnedValue.isDeserialized()).isFalse();
        Assertions.assertThat((String)returnedValue.getValueSerialized()).isEqualTo((Object)serializedValue);
    }

    @Deployment
    @Test
    public void testSubmitTaskFormContainingReadonlyVariable() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.formService.submitTaskForm(task.getId(), new HashMap());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testGetTaskFormWithoutLabels() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData formData = this.formService.getTaskFormData(task.getId());
        List formFields = formData.getFormFields();
        Assert.assertEquals((long)3L, (long)formFields.size());
        ArrayList<String> formFieldIds = new ArrayList<String>();
        for (FormField field : formFields) {
            Assert.assertNull((Object)field.getLabel());
            formFieldIds.add(field.getId());
        }
        Assert.assertTrue((boolean)formFieldIds.containsAll(Arrays.asList("stringField", "customField", "longField")));
        Object startForm = this.formService.getRenderedTaskForm(task.getId());
        Assert.assertNotNull((Object)startForm);
    }

    @Test
    public void testDeployTaskFormWithoutFieldTypes() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/form/FormServiceTest.testDeployTaskFormWithoutFieldTypes.bpmn20.xml").deploy();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("form field must have a 'type' attribute", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testGetStartFormWithoutLabels() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        StartFormData formData = this.formService.getStartFormData(processDefinition.getId());
        List formFields = formData.getFormFields();
        Assert.assertEquals((long)3L, (long)formFields.size());
        ArrayList<String> formFieldIds = new ArrayList<String>();
        for (FormField field : formFields) {
            Assert.assertNull((Object)field.getLabel());
            formFieldIds.add(field.getId());
        }
        Assert.assertTrue((boolean)formFieldIds.containsAll(Arrays.asList("stringField", "customField", "longField")));
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId());
        Assert.assertNotNull((Object)startForm);
    }

    @Test
    public void testDeployStartFormWithoutFieldTypes() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/form/FormServiceTest.testDeployStartFormWithoutFieldTypes.bpmn20.xml").deploy();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("form field must have a 'type' attribute", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/approve.form", "org/camunda/bpm/engine/test/api/form/util/request.form", "org/camunda/bpm/engine/test/api/form/util/adjustRequest.form"})
    @Test
    public void testTaskFormsWithVacationRequestProcess() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        Object startForm = this.formService.getRenderedStartForm(procDefId, "juel");
        Assert.assertNotNull((Object)startForm);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String processDefinitionId = processDefinition.getId();
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/api/form/util/request.form", (Object)this.formService.getStartFormData(processDefinitionId).getFormKey());
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("employeeName", "kermit");
        formProperties.put("numberOfDays", "4");
        formProperties.put("vacationMotivation", "I'm tired");
        this.formService.submitStartFormData(procDefId, formProperties);
        Task task = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        Assert.assertEquals((Object)"Vacation request by kermit", (Object)task.getDescription());
        Object taskForm = this.formService.getRenderedTaskForm(task.getId(), "juel");
        Assert.assertNotNull((Object)taskForm);
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"vacationApproved", (Object)"false"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Adjust vacation request", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testTaskFormUnavailable() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        Assert.assertNull((Object)this.formService.getRenderedStartForm(procDefId));
        this.runtimeService.startProcessInstanceByKey("noStartOrTaskForm");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((Object)this.formService.getRenderedTaskForm(task.getId()));
    }

    @Deployment
    @Test
    public void testBusinessKey() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startFormData = this.formService.getStartFormData(procDefId);
        FormField formField = (FormField)startFormData.getFormFields().get(0);
        Assert.assertTrue((boolean)formField.isBusinessKey());
    }

    @Deployment
    @Test
    public void testSubmitStartFormWithFormFieldMarkedAsBusinessKey() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance pi = this.formService.submitStartForm(procDefId, "foo", (Map)Variables.createVariables().putValue("secondParam", (Object)"bar"));
        Assert.assertEquals((Object)"foo", (Object)pi.getBusinessKey());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)((VariableInstance)result.get(0)).getName().equals("secondParam"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetDeployedStartForm() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        InputStream deployedStartForm = this.formService.getDeployedStartForm(procDefId);
        Assert.assertNotNull((Object)deployedStartForm);
        String fileAsString = IoUtil.fileAsString((String)"org/camunda/bpm/engine/test/api/form/start.form");
        String deployedStartFormAsString = IoUtil.inputStreamAsString((InputStream)deployedStartForm);
        Assert.assertEquals((Object)deployedStartFormAsString, (Object)fileAsString);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/EmbeddedDeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetEmbeddedDeployedStartForm() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        InputStream deployedStartForm = this.formService.getDeployedStartForm(procDefId);
        Assert.assertNotNull((Object)deployedStartForm);
        String fileAsString = IoUtil.fileAsString((String)"org/camunda/bpm/engine/test/api/form/start.form");
        String deployedStartFormAsString = IoUtil.inputStreamAsString((InputStream)deployedStartForm);
        Assert.assertEquals((Object)deployedStartFormAsString, (Object)fileAsString);
    }

    @Test
    public void testGetDeployedStartFormWithNullProcDefId() {
        try {
            this.formService.getDeployedStartForm(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertEquals((Object)"Process definition id cannot be null: processDefinitionId is null", (Object)e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetDeployedTaskForm() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        InputStream deployedTaskForm = this.formService.getDeployedTaskForm(taskId);
        Assert.assertNotNull((Object)deployedTaskForm);
        String fileAsString = IoUtil.fileAsString((String)"org/camunda/bpm/engine/test/api/form/task.form");
        String deployedStartFormAsString = IoUtil.inputStreamAsString((InputStream)deployedTaskForm);
        Assert.assertEquals((Object)deployedStartFormAsString, (Object)fileAsString);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedFormsCase.cmmn11.xml", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetDeployedTaskForm_Case() {
        this.caseService.createCaseInstanceByKey("Case_1");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        InputStream deployedTaskForm = this.formService.getDeployedTaskForm(taskId);
        Assert.assertNotNull((Object)deployedTaskForm);
        String fileAsString = IoUtil.fileAsString((String)"org/camunda/bpm/engine/test/api/form/task.form");
        String deployedStartFormAsString = IoUtil.inputStreamAsString((InputStream)deployedTaskForm);
        Assert.assertEquals((Object)deployedStartFormAsString, (Object)fileAsString);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/EmbeddedDeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetEmbeddedDeployedTaskForm() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        InputStream deployedTaskForm = this.formService.getDeployedTaskForm(taskId);
        Assert.assertNotNull((Object)deployedTaskForm);
        String fileAsString = IoUtil.fileAsString((String)"org/camunda/bpm/engine/test/api/form/task.form");
        String deployedStartFormAsString = IoUtil.inputStreamAsString((InputStream)deployedTaskForm);
        Assert.assertEquals((Object)deployedStartFormAsString, (Object)fileAsString);
    }

    @Test
    public void testGetDeployedTaskFormWithNullTaskId() {
        try {
            this.formService.getDeployedTaskForm(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertEquals((Object)"Task id cannot be null: taskId is null", (Object)e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/task.form"})
    @Test
    public void testGetDeployedStartForm_DeploymentNotFound() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        try {
            this.formService.getDeployedStartForm(procDefId);
            Assert.fail((String)"Exception expected");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("The form with the resource name 'org/camunda/bpm/engine/test/api/form/start.form' cannot be found in deployment.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form"})
    @Test
    public void testGetDeployedTaskForm_DeploymentNotFound() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        try {
            this.formService.getDeployedTaskForm(taskId);
            Assert.fail((String)"Exception expected");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("The form with the resource name 'org/camunda/bpm/engine/test/api/form/task.form' cannot be found in deployment.", e.getMessage());
        }
    }

    @Test
    public void testGetDeployedStartForm_FormKeyNotSet() {
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        try {
            this.formService.getDeployedStartForm(processDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("The form key is not set.", e.getMessage());
        }
    }

    @Test
    public void testGetDeployedTaskForm_FormKeyNotSet() {
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        try {
            this.formService.getDeployedTaskForm(taskId);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("The form key is not set.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.testGetDeployedStartFormWithWrongKeyFormat.bpmn20.xml"})
    @Test
    public void testGetDeployedStartFormWithWrongKeyFormat() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        try {
            this.formService.getDeployedStartForm(processDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("The form key 'formKey' does not reference a deployed form.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.testGetDeployedTaskFormWithWrongKeyFormat.bpmn20.xml"})
    @Test
    public void testGetDeployedTaskFormWithWrongKeyFormat() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        try {
            this.formService.getDeployedTaskForm(taskId);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("The form key 'formKey' does not reference a deployed form.", e.getMessage());
        }
    }
}

