/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerCommentsTest
extends AbstractHistoryCleanupSchedulerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return AbstractHistoryCleanupSchedulerTest.configure(configuration, new HistoryEventTypes[0]);
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask("userTask").name("userTask")).endEvent().done();

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void shouldScheduleToNow() {
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.taskService.createComment(null, processInstanceId, "aMessage");
        }
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldScheduleToLater() {
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.taskService.createComment(null, processInstanceId, "aMessage");
        }
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)removalTime, (int)10)));
    }
}

