/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class SuspendJobTest
extends PluggableProcessEngineTestCase {
    public void testSuspensionById_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobById(null);
            SuspendJobTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionById_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobById(job.getId());
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        SuspendJobTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByJobDefinitionId_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByJobDefinitionId(jobDefinition.getId());
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        SuspendJobTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessInstanceId_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessInstanceId(processInstance.getId());
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        SuspendJobTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        SuspendJobTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionId_shouldSuspendJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessDefinitionId(processDefinition.getId());
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        SuspendJobTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKey_shouldSuspendJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessDefinitionKey(processDefinition.getKey());
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        SuspendJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        SuspendJobTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldSuspendJob() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobByProcessDefinitionKey(key);
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        SuspendJobTest.assertFalse((boolean)job.isSuspended());
        this.managementService.updateJobSuspensionState().byJobId(job.getId()).suspend();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByJobDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byJobDefinitionId(jobDefinition.getId()).suspend();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessInstanceIdUsingBuilder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobSuspensionState().byProcessInstanceId(processInstance.getId()).suspend();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testSuspensionByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey("suspensionProcess").suspend();
        SuspendJobTest.assertEquals((long)0L, (long)jobQuery.active().count());
        SuspendJobTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }
}

