/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mock;

import java.util.HashMap;
import junit.framework.TestCase;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MocksTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    public void testMethodsOfMocksAPI() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < 5; ++i) {
            map.put("key" + i, new Object());
        }
        for (String key : map.keySet()) {
            Mocks.register((String)key, map.get(key));
        }
        for (String key : map.keySet()) {
            TestCase.assertEquals(map.get(key), (Object)Mocks.get((Object)key));
        }
        TestCase.assertEquals(map, (Object)Mocks.getMocks());
        Mocks.reset();
        for (String key : map.keySet()) {
            TestCase.assertNull((Object)Mocks.get((Object)key));
        }
        TestCase.assertEquals((int)0, (int)Mocks.getMocks().size());
    }

    @Test
    @Deployment
    public void testMockAvailabilityInScriptTask() {
        this.testMockAvailability();
    }

    @Test
    @Deployment
    public void testMockAvailabilityInExpressionLanguage() {
        this.testMockAvailability();
    }

    private void testMockAvailability() {
        String testStr = "testValue";
        Mocks.register((String)"myMock", (Object)new Object(){

            public String getTest() {
                return "testValue";
            }

            public void testMethod(DelegateExecution execution, String str) {
                execution.setVariable("testVar", (Object)str);
            }
        });
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("mocksTest");
        Mocks.reset();
        TestCase.assertEquals((Object)"testValue", (Object)this.runtimeService.getVariable(pi.getId(), "testVar"));
    }
}

