/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDecisionEvaluationTest
extends PluggableProcessEngineTestCase {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_FILE_SECOND_VERSION = "org/camunda/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String RESULT_OF_FIRST_VERSION = "ok";
    protected static final String RESULT_OF_SECOND_VERSION = "notok";

    public void testFailToEvaluateDecisionByIdWithoutTenantId() {
        this.deployment(new String[]{DMN_FILE});
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).decisionDefinitionWithoutTenantId().evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToEvaluateDecisionByIdWithTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToEvaluateDecisionByKeyForNonExistingTenantID() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId("nonExistingTenantId").evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key 'decision' and tenant-id 'nonExistingTenantId'"));
        }
    }

    public void testFailToEvaluateDecisionByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants."));
        }
    }

    public void testEvaluateDecisionByKeyWithoutTenantId() {
        this.deployment(new String[]{DMN_FILE});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionWithoutTenantId().evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyForAnyTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_SECOND_VERSION});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyLatestVersionAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE_SECOND_VERSION});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
    }

    public void testEvaluateDecisionByKeyVersionAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_SECOND_VERSION});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).version(Integer.valueOf(1)).decisionDefinitionTenantId(TENANT_TWO).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deployment(new String[]{DMN_FILE});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionWithoutTenantId().variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testFailToEvaluateDecisionByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key 'decision'"));
        }
    }

    public void testFailToEvaluateDecisionByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot evaluate the decision"));
        }
    }

    public void testFailToEvaluateDecisionByIdNoAuthenticatedTenants() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
            MultiTenancyDecisionEvaluationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot evaluate the decision"));
        }
    }

    public void testEvaluateDecisionByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByIdAuthenticatedTenant() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_SECOND_VERSION});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    public void testEvaluateDecisionByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasResult(DmnDecisionResult decisionResult, Object expectedValue) {
        Assert.assertThat((Object)decisionResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)decisionResult.size(), (Matcher)CoreMatchers.is((Object)1));
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)expectedValue));
    }
}

