/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySignalReceiveTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance SIGNAL_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"signalStart").startEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"signalCatch").startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_INTERMEDIATE_THROW_PROCESS = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().intermediateThrowEvent().signal("signal")).endEvent().done();
    protected static final BpmnModelInstance SIGNAL_END_THROW_PROCESS = ((EndEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().endEvent().signal("signal")).done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void sendSignalToStartEventForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createSignalEvent("signal").withoutTenantId().send();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void sendSignalToStartEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_TWO).send();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToStartEventWithoutTenantIdForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToStartEventWithoutTenantIdForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventForNonTenant() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").withoutTenantId().send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Task)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void sendSignalToIntermediateCatchEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithoutTenantIdForNonTenant() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithoutTenantIdForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").withoutTenantId().send();
        List tasks = this.engineRule.getTaskService().createTaskQuery().list();
        Assert.assertThat((Object)tasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Task)tasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Task)tasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.engineRule.getRuntimeService().createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void sendSignalToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").execute();
        this.engineRule.getRuntimeService().createSignalEvent("signal").send();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToSendSignalWithExecutionIdForTenant() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("Cannot specify a tenant-id when deliver a signal to a single execution.");
        this.engineRule.getRuntimeService().createSignalEvent("signal").executionId("id").tenantId(TENANT_ONE).send();
    }

    @Test
    public void throwIntermediateSignalForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void throwIntermediateSignalForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void throwEndSignalForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void throwEndSignalForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

