/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDecisionTaskTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN_LATEST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTask.cmmn";
    protected static final String CMMN_DEPLOYMENT = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskDeploymentBinding.cmmn";
    protected static final String CMMN_VERSION = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskVersionBinding.cmmn";
    protected static final String CMMN_VERSION_2 = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskVersionBinding_v2.cmmn";
    protected static final String CMMN_CONST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskTenantIdConst.cmmn";
    protected static final String CMMN_WITHOUT_TENANT = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskWithoutTenantId.cmmn";
    protected static final String CMMN_EXPR = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithDecisionTaskTenantIdExpr.cmmn";
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String DMN_FILE_VERSION_TWO = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable_v2.dmn";
    protected static final String CASE_DEFINITION_KEY = "caseDecisionTask";
    protected static final String DECISION_TASK_ID = "PI_DecisionTask_1";
    protected static final String RESULT_OF_VERSION_ONE = "A";
    protected static final String RESULT_OF_VERSION_TWO = "C";

    public void testEvaluateDecisionWithDeploymentBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_DEPLOYMENT, DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_DEPLOYMENT, DMN_FILE_VERSION_TWO});
        CaseInstance caseInstanceOne = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
        CaseInstance caseInstanceTwo = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_TWO);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithLatestBindingSameVersion() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_LATEST, DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_LATEST, DMN_FILE_VERSION_TWO});
        CaseInstance caseInstanceOne = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
        CaseInstance caseInstanceTwo = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_TWO);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithLatestBindingDifferentVersions() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_LATEST, DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_LATEST, DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_LATEST, DMN_FILE_VERSION_TWO});
        CaseInstance caseInstanceOne = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
        CaseInstance caseInstanceTwo = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_TWO);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testEvaluateDecisionWithVersionBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_VERSION, DMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE_VERSION_TWO});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_VERSION, DMN_FILE_VERSION_TWO});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        CaseInstance caseInstanceOne = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
        CaseInstance caseInstanceTwo = this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_TWO);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_TWO));
    }

    public void testFailEvaluateDecisionFromOtherTenantWithDeploymentBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_DEPLOYMENT});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
            MultiTenancyDecisionTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithLatestBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_LATEST});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
            MultiTenancyDecisionTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithVersionBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_VERSION_2, DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.createCaseInstance(CASE_DEFINITION_KEY, TENANT_ONE);
            MultiTenancyDecisionTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision', version = '2' and tenant-id 'tenant1'"));
        }
    }

    public void testEvaluateDecisionRefTenantIdConstant() {
        this.deployment(new String[]{CMMN_CONST});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        CaseInstance caseInstance = this.createCaseInstance(CASE_DEFINITION_KEY);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstance.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    public void testEvaluateDecisionRefWithoutTenantIdConstant() {
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_WITHOUT_TENANT});
        this.deployment(new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        CaseInstance caseInstance = this.createCaseInstance(CASE_DEFINITION_KEY);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstance.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    public void testEvaluateDecisionRefTenantIdExpression() {
        this.deployment(new String[]{CMMN_EXPR});
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        CaseInstance caseInstance = this.createCaseInstance(CASE_DEFINITION_KEY);
        Assert.assertThat((Object)((String)this.caseService.getVariable(caseInstance.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)RESULT_OF_VERSION_ONE));
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey, String tenantId) {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinitionKey).caseDefinitionTenantId(tenantId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(DECISION_TASK_ID).tenantIdIn(new String[]{tenantId}).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).setVariable("status", (Object)"gold").manualStart();
        return caseInstance;
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(DECISION_TASK_ID).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).setVariable("status", (Object)"gold").manualStart();
        return caseInstance;
    }
}

