/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessInstanceQueryByLeafInstancesTest {
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected RuntimeService runtimeService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesThreeLayers() {
        ProcessInstance threeLayerProcess = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)3L));
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").count(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSimpleSubProcess").count(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)simpleSubProcessQuery.count(), (Matcher)Is.is((Object)1L));
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assert.assertThat((Object)instance.getRootProcessInstanceId(), (Matcher)Is.is((Object)threeLayerProcess.getId()));
        Assert.assertThat((Object)instance.getId(), (Matcher)Is.is((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesTwoLayers() {
        ProcessInstance twoLayerProcess = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSimpleSubProcess").count(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)simpleSubProcessQuery.count(), (Matcher)Is.is((Object)1L));
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assert.assertThat((Object)instance.getRootProcessInstanceId(), (Matcher)Is.is((Object)twoLayerProcess.getId()));
        Assert.assertThat((Object)instance.getId(), (Matcher)Is.is((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesOneLayer() {
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)simpleSubProcessQuery.count(), (Matcher)Is.is((Object)1L));
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assert.assertThat((Object)instance.getRootProcessInstanceId(), (Matcher)Is.is((Object)process.getId()));
        Assert.assertThat((Object)instance.getId(), (Matcher)Is.is((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId()));
    }
}

