/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.TypedValueAssert;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class ProcessInstantiationWithVariablesInReturnTest {
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String SET_VARIABLE_IN_DELEGATE_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegate.bpmn20.xml";
    protected static final String SET_VARIABLE_IN_DELEGATE_WITH_WAIT_STATE_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegateWithWaitState.bpmn20.xml";
    protected static final String SIMPLE_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.simpleProcess.bpmn20.xml";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    private void checkVariables(VariableMap map, int expectedSize) {
        List variables = ((HistoricVariableInstanceQuery)this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        TestCase.assertEquals((int)expectedSize, (int)variables.size());
        TestCase.assertEquals((int)variables.size(), (int)map.size());
        for (HistoricVariableInstance instance : variables) {
            TestCase.assertTrue((boolean)map.containsKey((Object)instance.getName()));
            Object instanceValue = instance.getTypedValue().getValue();
            Object mapValue = map.getValueTyped(instance.getName()).getValue();
            if (instanceValue == null) {
                TestCase.assertNull((Object)mapValue);
                continue;
            }
            if (instanceValue instanceof byte[]) {
                TestCase.assertTrue((boolean)Arrays.equals((byte[])instanceValue, (byte[])mapValue));
                continue;
            }
            TestCase.assertEquals((Object)instanceValue, (Object)mapValue);
        }
    }

    private void testVariablesWithoutDeserialization(String processDefinitionKey) throws Exception {
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey(processDefinitionKey).setVariable("serializedVar", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName(JavaSerializable.class.getName()).create())).executeWithVariablesInReturn(false, false);
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        ObjectValue serializedVar = (ObjectValue)map.getValueTyped("serializedVar");
        TestCase.assertFalse((boolean)serializedVar.isDeserialized());
        TypedValueAssert.assertObjectValueSerializedJava(serializedVar, javaSerializable);
        try {
            serializedVar.getValue();
            Assert.fail((String)"Deserialization should fail!");
        }
        catch (IllegalStateException ise) {
            TestCase.assertTrue((boolean)ise.getMessage().equals("Object is not deserialized."));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.simpleProcess.bpmn20.xml"})
    public void testReturnVariablesFromStartWithoutDeserialization() throws Exception {
        this.testVariablesWithoutDeserialization("simpleProcess");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testReturnVariablesFromStartWithoutDeserializationWithWaitstate() throws Exception {
        this.testVariablesWithoutDeserialization("subprocess");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.simpleProcess.bpmn20.xml"})
    public void testReturnVariablesFromStart() {
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey("simpleProcess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)new byte[]{127, 34, 64}))).executeWithVariablesInReturn(false, false);
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 4);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testReturnVariablesFromStartWithWaitstate() {
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey("subprocess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)new byte[]{127, 34, 64}))).executeWithVariablesInReturn(false, false);
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 4);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testReturnVariablesFromStartWithWaitstateStartInSubProcess() {
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey("subprocess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)new byte[]{127, 34, 64}))).startBeforeActivity("innerTask")).executeWithVariablesInReturn(true, true);
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 4);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegate.bpmn20.xml"})
    public void testReturnVariablesFromExecution() {
        ProcessInstanceWithVariables procInstance = this.engineRule.getRuntimeService().createProcessInstanceByKey("variableProcess").executeWithVariablesInReturn();
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 8);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegateWithWaitState.bpmn20.xml"})
    public void testReturnVariablesFromExecutionWithWaitstate() {
        ProcessInstanceWithVariables procInstance = this.engineRule.getRuntimeService().createProcessInstanceByKey("variableProcess").executeWithVariablesInReturn();
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 8);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegate.bpmn20.xml"})
    public void testReturnVariablesFromStartAndExecution() {
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey("variableProcess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)new byte[]{127, 34, 64}))).executeWithVariablesInReturn();
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 12);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationWithVariablesInReturn.setVariableInDelegateWithWaitState.bpmn20.xml"})
    public void testReturnVariablesFromStartAndExecutionWithWaitstate() {
        ProcessInstanceWithVariables procInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey("variableProcess").setVariable("stringVar", (Object)"aValue1")).setVariableLocal("integerVar", (Object)56789)).setVariables((Map)Variables.createVariables().putValue("longVar", (Object)123L))).setVariablesLocal((Map)Variables.createVariables().putValue("byteVar", (Object)new byte[]{127, 34, 64}))).executeWithVariablesInReturn(false, false);
        VariableMap map = procInstance.getVariables();
        TestCase.assertNotNull((Object)map);
        this.checkVariables(map, 8);
    }
}

