/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.util;

import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.camunda.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;

public class TimerEventFactory
implements BpmnEventFactory {
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";

    @Override
    public MigratingBpmnEventTrigger addBoundaryEvent(ProcessEngine engine, BpmnModelInstance modelInstance, String activityId, String boundaryEventId) {
        ((BoundaryEventBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).activityBuilder(activityId).boundaryEvent(boundaryEventId).timerWithDate(TIMER_DATE)).done();
        TimerEventTrigger trigger = new TimerEventTrigger();
        trigger.engine = engine;
        trigger.activityId = boundaryEventId;
        trigger.handlerType = "timer-transition";
        return trigger;
    }

    @Override
    public MigratingBpmnEventTrigger addEventSubProcess(ProcessEngine engine, BpmnModelInstance modelInstance, String parentId, String subProcessId, String startEventId) {
        ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).addSubProcessTo(parentId).id(subProcessId)).triggerByEvent()).embeddedSubProcess().startEvent(startEventId).timerWithDuration("PT10M")).subProcessDone().done();
        TimerEventTrigger trigger = new TimerEventTrigger();
        trigger.engine = engine;
        trigger.activityId = startEventId;
        trigger.handlerType = "timer-start-event-subprocess";
        return trigger;
    }

    protected static class TimerEventTrigger
    implements MigratingBpmnEventTrigger {
        protected ProcessEngine engine;
        protected String activityId;
        protected String handlerType;

        protected TimerEventTrigger() {
        }

        @Override
        public void trigger(String processInstanceId) {
            ManagementService managementService = this.engine.getManagementService();
            Job timerJob = (Job)managementService.createJobQuery().processInstanceId(processInstanceId).activityId(this.activityId).singleResult();
            if (timerJob == null) {
                throw new ProcessEngineException("No job for this event found in context of process instance " + processInstanceId);
            }
            managementService.executeJob(timerJob.getId());
        }

        @Override
        public void assertEventTriggerMigrated(MigrationTestRule migrationContext, String targetActivityId) {
            migrationContext.assertJobMigrated(this.activityId, targetActivityId, this.handlerType);
        }

        @Override
        public MigratingBpmnEventTrigger inContextOf(String newActivityId) {
            TimerEventTrigger newTrigger = new TimerEventTrigger();
            newTrigger.activityId = newActivityId;
            newTrigger.engine = this.engine;
            newTrigger.handlerType = this.handlerType;
            return newTrigger;
        }
    }
}

