/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.end;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class SignalEndEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchSignalEndEventInEmbeddedSubprocess() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("catchSignalEndEventInEmbeddedSubprocess");
        SignalEndEventTest.assertNotNull((Object)processInstance);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        SignalEndEventTest.assertEquals((String)"subprocessTask", (String)task.getName());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        SignalEndEventTest.assertEquals((String)"task after catching the signal", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/end/SignalEndEventTest.catchSignalEndEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/end/SignalEndEventTest.processWithSignalEndEvent.bpmn20.xml"})
    public void testCatchSignalEndEventInCallActivity() throws Exception {
        ProcessInstance processInstanceCatchEvent = this.runtimeService.startProcessInstanceByKey("catchSignalEndEvent");
        SignalEndEventTest.assertNotNull((Object)processInstanceCatchEvent);
        SignalEndEventTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        SignalEndEventTest.assertEquals((String)"alert", (String)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName());
        ProcessInstance processInstanceEndEvent = this.runtimeService.startProcessInstanceByKey("processWithSignalEndEvent");
        SignalEndEventTest.assertNotNull((Object)processInstanceEndEvent);
        this.assertProcessEnded(processInstanceEndEvent.getId());
        SignalEndEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        SignalEndEventTest.assertEquals((String)"taskAfterSignalCatch", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceCatchEvent.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/testPropagateOutputVariablesWhileThrowSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEndEventTest.parent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowSignal() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("SignalParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/testPropagateOutputVariablesWhileThrowSignal2.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEndEventTest.parent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowSignal2() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("SignalParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("inside subprocess").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    protected void checkOutput(String processInstanceId) {
        SignalEndEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched signal").count());
        SignalEndEventTest.assertNotNull((Object)this.runtimeService.getVariable(processInstanceId, "cancelReason"));
        SignalEndEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "input"));
    }
}

