/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowBpmnErrorDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UnhandledBpmnErrorTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setEnableExceptionsAfterUnhandledBpmnError(true);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void testThrownInJavaDelegate() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"no error handler"));
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass(ThrowBpmnErrorDelegate.class)).endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Test
    @Deployment
    public void testUncaughtErrorSimpleProcess() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"no error handler"));
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Test
    @Deployment
    public void testUnhandledErrorInEmbeddedSubprocess() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"no error handler"));
        this.runtimeService.startProcessInstanceByKey("boundaryErrorOnEmbeddedSubprocess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        this.taskService.complete(task.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/UnhandledBpmnErrorTest.testUncaughtErrorOnCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/UnhandledBpmnErrorTest.subprocess.bpmn20.xml"})
    public void testUncaughtErrorOnCallActivity() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"no error handler"));
        this.runtimeService.startProcessInstanceByKey("uncaughtErrorOnCallActivity");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)task.getName());
        this.taskService.complete(task.getId());
    }

    @Test
    @Deployment
    public void testUncaughtErrorOnEventSubprocess() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"no error handler"));
        this.runtimeService.startProcessInstanceByKey("process").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"subprocessTask", (Object)task.getName());
        this.taskService.complete(task.getId());
    }
}

