/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.TestExecutionListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MessageEventSubprocessTest
extends PluggableProcessEngineTestCase {
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            TestExecutionListener.reset();
        }
    }

    @Deployment
    public void testInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(1);
    }

    @Deployment
    public void testTwoInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(2);
    }

    private void testInterruptingUnderProcessDefinition(int expectedNumberOfEventSubscriptions) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)expectedNumberOfEventSubscriptions, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcessTask", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    public void testNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    public void testNestedEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    public void testNestedNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    public void testEventSubprocessBoundaryListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess", (String)taskInEventSubProcess.getTaskDefinitionKey());
        this.runtimeService.correlateMessage("message2");
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-start", (String)collectedEvents.get(0));
        MessageEventSubprocessTest.assertEquals((String)"taskInMainFlow-end", (String)collectedEvents.get(1));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-start", (String)collectedEvents.get(2));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-start", (String)collectedEvents.get(3));
        MessageEventSubprocessTest.assertEquals((String)"startEventInSubProcess-end", (String)collectedEvents.get(4));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-start", (String)collectedEvents.get(5));
        MessageEventSubprocessTest.assertEquals((String)"taskInEventSubProcess-end", (String)collectedEvents.get(6));
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcess-end", (String)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").canceled().count());
            MessageEventSubprocessTest.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingUnderProcessDefinitionScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)execution);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    public void testMultipleNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution subProcess = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)subProcess);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task subProcessTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("subProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)subProcessTask);
        for (int i = 1; i < 3; ++i) {
            this.runtimeService.messageEventReceived("newMessage", subProcess.getId());
            List eventSubProcessTasks = this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").list();
            MessageEventSubprocessTest.assertEquals((int)i, (int)eventSubProcessTasks.size());
        }
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("subProcessTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().up().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.taskService.complete(subProcessTask.getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    public void testNonInterruptingInMultiParallelEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageEventSubprocessTest.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            MessageEventSubprocessTest.assertEquals((String)"subUserTask", (String)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        for (EventSubscription es : this.runtimeService.createEventSubscriptionQuery().list()) {
            this.runtimeService.messageEventReceived("message", es.getExecutionId());
        }
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        tasks = this.taskService.createTaskQuery().taskName("Message User Task").list();
        MessageEventSubprocessTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        MessageEventSubprocessTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskName("Message User Task").list().size());
        tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingInMultiSequentialEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Message User Task").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        MessageEventSubprocessTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingWithParallelForkInsideEmbeddedSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("firstUserTask").concurrent().noScope().up().child("secondUserTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").done());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingWithReceiveTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("receiveTask").scope().up().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.runtimeService.correlateMessage("secondMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task2);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("userTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingWithAsyncConcurrentTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("message");
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)asyncJob);
        this.managementService.executeJob(asyncJob.getId());
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task processTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        Task eventSubprocessTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)processTask);
        MessageEventSubprocessTest.assertNotNull((Object)eventSubprocessTask);
        this.taskService.complete(processTask.getId());
        this.taskService.complete(eventSubprocessTask.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingWithReceiveTaskInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageEventSubprocessTest.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingWithUserTaskAndBoundaryEventInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("newMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageEventSubprocessTest.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingOutsideEmbeddedSubProcessWithReceiveTaskInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        this.runtimeService.correlateMessage("secondMessage");
        MessageEventSubprocessTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        MessageEventSubprocessTest.assertNotNull((Object)task2);
        MessageEventSubprocessTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testInterruptingActivityInstanceTree() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("newMessage");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().endScope().done());
    }

    @Deployment
    public void testNonInterruptingActivityInstanceTree() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("newMessage");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().endScope().done());
    }

    @Deployment
    public void testNonInterruptingWithTerminatingEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Inner User Task"));
        this.runtimeService.correlateMessage("message");
        Task eventSubprocessTask = (Task)this.taskService.createTaskQuery().taskName("Event User Task").singleResult();
        Assert.assertThat((Object)eventSubprocessTask, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.taskService.complete(eventSubprocessTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("SubProcess_1").activity("UserTask_1").endScope().endScope().done());
    }

    @Deployment
    public void testExpressionInMessageNameInInterruptingSubProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage-foo", processInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageEventSubprocessTest.assertEquals((String)"eventSubProcessTask", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }
}

